/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import me.zcraft.tconfig.config.TritiumConfig;
import net.minecraft.class_1150;
import net.minecraft.class_1366;
import net.minecraft.class_1653;
import net.minecraft.class_231;
import net.minecraft.class_2552;
import net.minecraft.class_3460;
import net.minecraft.class_795;
import net.minecraft.class_864;
import net.minecraft.class_988;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;

public final class EntityTickHelper {
    private static final AtomicReference<Set<class_3460<?>>> WHITE_LIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<class_3460<?>>> BLACK_LIST = new AtomicReference(Collections.emptySet());
    private static final List<WildcardPattern> WHITE_PATTERNS = new ArrayList<WildcardPattern>();
    private static final List<WildcardPattern> BLACK_PATTERNS = new ArrayList<WildcardPattern>();
    private static final boolean ignoreDeadEntities = true;
    private static volatile boolean enabled = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    public static boolean shouldSkipTick(class_864 entity) {
        if (!enabled) {
            return false;
        }
        if (!entity.method_2476()) {
            return false;
        }
        if (!entity.method_2476()) {
            return true;
        }
        class_3460 type = entity.method_15557();
        if (EntityTickHelper.matchesWildcard(type, BLACK_PATTERNS) || BLACK_LIST.get().contains(type)) {
            return true;
        }
        if (EntityTickHelper.matchesWildcard(type, WHITE_PATTERNS) || WHITE_LIST.get().contains(type)) {
            return false;
        }
        return !EntityTickHelper.isNearPlayer(entity);
    }

    private static void reloadConfig() {
        enabled = TritiumConfigBase.Entities.EntityOpt.optimizeEntities;
        horizontalRange = TritiumConfigBase.Entities.EntityOpt.horizontalRange;
        verticalRange = TritiumConfigBase.Entities.EntityOpt.verticalRange;
        List<String> whiteRaw = TritiumConfigBase.Entities.EntityOpt.entityWhitelist;
        HashSet whiteIds = Sets.newHashSet();
        WHITE_PATTERNS.clear();
        BLACK_PATTERNS.clear();
        for (String s : whiteRaw) {
            EntityTickHelper.parseEntry(s, whiteIds);
        }
        WHITE_LIST.set((Set<class_3460<?>>)ImmutableSet.copyOf((Collection)whiteIds));
    }

    private static void parseEntry(String raw, Set<class_3460<?>> idTarget) {
        if (raw.contains("*") || raw.contains("?")) {
            WHITE_PATTERNS.add(new WildcardPattern(raw));
        } else {
            try {
                class_1653 key = new class_1653(raw);
                class_3460 type = (class_3460)class_1366.field_21330.method_19956(key);
                if (type != null) {
                    idTarget.add(type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean matchesWildcard(class_3460<?> type, List<WildcardPattern> list) {
        class_1653 id = class_1366.field_21330.method_19959(type);
        if (id == null) {
            return false;
        }
        String str = id.toString();
        for (WildcardPattern p : list) {
            if (!p.matches(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearPlayer(class_864 entity) {
        class_1150 level = entity.field_3248;
        if (!(level instanceof class_795)) {
            return true;
        }
        class_795 sl = (class_795)level;
        class_2552 pos = entity.method_4086();
        int cx = pos.method_10572() >> 4;
        int cz = pos.method_10574() >> 4;
        int radius = (horizontalRange >> 4) + 1;
        class_231 box = new class_231((double)(pos.method_10572() - horizontalRange), (double)(pos.method_10573() - verticalRange), (double)(pos.method_10574() - horizontalRange), (double)(pos.method_10572() + horizontalRange), (double)(pos.method_10573() + verticalRange), (double)(pos.method_10574() + horizontalRange));
        for (class_988 player : sl.field_4544) {
            if (!player.method_2476()) continue;
            class_2552 ppos = player.method_4086();
            int pcx = ppos.method_10572() >> 4;
            int pcz = ppos.method_10574() >> 4;
            if (Math.abs(pcx - cx) > radius || Math.abs(pcz - cz) > radius || !player.method_10945().method_12115(box)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            TritiumConfig config = TritiumConfig.getConfig("tritium");
            config.addReloadListener(EntityTickHelper::reloadConfig);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to register config reload listener", (Throwable)e);
        }
        EntityTickHelper.reloadConfig();
    }

    private static final class WildcardPattern {
        private final Pattern regex;

        WildcardPattern(String raw) {
            String s = raw.replace("?", ".{1}").replace("*", ".*");
            this.regex = Pattern.compile("^" + s + "$");
        }

        boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }
    }
}

