/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import me.zcraft.tconfig.config.TritiumConfig;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_437;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.TritiumConfigScreenFactory;

@Environment(value=EnvType.CLIENT)
public class TritiumConfigScreenReg
implements ModMenuApi {
    public static void registerConfigScreen() {
        try {
            String modId = ((ModContainer)FabricLoader.getInstance().getModContainer("tritium").orElseThrow(() -> new IllegalStateException("Mod container not found"))).getMetadata().getId();
            TritiumConfigScreenReg.registerConfigScreenInternal(modId, TritiumConfig.getConfig(modId));
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to auto-register config screen for current mod", (Throwable)e);
        }
    }

    public static void registerConfigScreen(String modId) {
        try {
            TritiumConfigScreenReg.registerConfigScreenInternal(modId, TritiumConfig.getConfig(modId));
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to register config screen for mod: {}", (Object)modId, (Object)e);
        }
    }

    public static void registerConfigScreen(TritiumConfig config) {
        try {
            TritiumConfigScreenReg.registerConfigScreenInternal(config.getModId(), config);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to register config screen for config: {}", (Object)config.getConfigClass().getName(), (Object)e);
        }
    }

    private static void registerConfigScreenInternal(String modId, TritiumConfig config) {
        if (config == null) {
            TritiumCommon.LOG.warn("No configuration found for mod: {}. Call TritiumConfig.register() first.", (Object)modId);
            return;
        }
        if (!config.isClientEnvironment()) {
            TritiumCommon.LOG.debug("Skipping config screen registration for mod {} in server environment", (Object)modId);
            return;
        }
        TritiumCommon.LOG.info("Config screen registered for mod: {} (available through ModMenu)", (Object)modId);
    }

    public static class_437 createConfigScreen(class_437 parent, TritiumConfig config) {
        return TritiumConfigScreenFactory.createConfigScreen(parent, config);
    }

    public static class_437 createConfigScreen(class_437 parent, String modId) {
        return TritiumConfigScreenFactory.createConfigScreen(parent, TritiumConfig.getConfig(modId));
    }

    private static class_437 createConfigScreen(class_437 parent, String modId, TritiumConfig config) {
        return TritiumConfigScreenFactory.createConfigScreen(parent, config);
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> TritiumConfigScreenReg.createConfigScreen(parent, "tritium");
    }
}

