/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.cache;

import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2609;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2609.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Unique
    private static final int CACHE_INVALIDATION_TICKS = 200;
    @Unique
    private static final int DEFAULT_COOK_TIME = 200;
    @Unique
    private int tritium$cacheTicks = 0;
    @Unique
    @Nullable
    private class_8786<? extends class_1874> tritium$cachedRecipe;
    @Unique
    @Nullable
    private class_1799 tritium$cachedInput;
    @Unique
    private boolean tritium$cacheMissed = false;
    @Shadow
    @Final
    private class_1863.class_7266<class_9696, ? extends class_1874> field_38234;
    @Shadow
    protected class_2371<class_1799> field_11984;

    @Shadow
    private static int method_17029(class_1937 level, class_2609 blockEntity) {
        throw new AssertionError();
    }

    @Unique
    private boolean tritium$isInputChanged(class_1799 currentInput) {
        if (this.tritium$cachedInput == null) {
            return !currentInput.method_7960();
        }
        if (currentInput.method_7960()) {
            return true;
        }
        return !class_1799.method_7984((class_1799)this.tritium$cachedInput, (class_1799)currentInput) || !class_1799.method_31577((class_1799)this.tritium$cachedInput, (class_1799)currentInput);
    }

    @Unique
    @Nullable
    private class_8786<? extends class_1874> tritium$getCachedRecipe(class_1799 currentInput) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return null;
        }
        ++this.tritium$cacheTicks;
        if (this.tritium$cacheTicks >= 200 || this.tritium$isInputChanged(currentInput)) {
            this.tritium$resetCache();
            return null;
        }
        return this.tritium$cacheMissed ? null : this.tritium$cachedRecipe;
    }

    @Unique
    private void tritium$updateCache(class_1937 level, class_1799 input) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        this.tritium$resetCache();
        if (input.method_7960()) {
            return;
        }
        class_9696 recipeInput = new class_9696(input);
        Optional recipe = this.field_38234.method_42303((class_9695)recipeInput, level);
        if (recipe.isPresent()) {
            this.tritium$cachedRecipe = (class_8786)recipe.get();
            this.tritium$cachedInput = input.method_7972();
            this.tritium$cacheMissed = false;
        } else {
            this.tritium$cacheMissed = true;
            this.tritium$cachedInput = input.method_7972();
        }
        this.tritium$cacheTicks = 0;
    }

    @Unique
    private void tritium$resetCache() {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        this.tritium$cachedRecipe = null;
        this.tritium$cachedInput = null;
        this.tritium$cacheMissed = false;
        this.tritium$cacheTicks = 0;
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;getTotalCookTime(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)I"))
    private static int redirectGetTotalCookTime(class_1937 level, class_2609 blockEntity) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return AbstractFurnaceBlockEntityMixin.method_17029(level, blockEntity);
        }
        return ((AbstractFurnaceBlockEntityMixin)blockEntity).tritium$getCachedTotalCookTime(level);
    }

    @Unique
    private int tritium$getCachedTotalCookTime(class_1937 level) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return AbstractFurnaceBlockEntityMixin.method_17029(level, (class_2609)this);
        }
        if (this.field_11984.isEmpty()) {
            if (this.tritium$cachedInput != null || !this.tritium$cacheMissed) {
                this.tritium$resetCache();
            }
            return 200;
        }
        class_1799 currentInput = (class_1799)this.field_11984.getFirst();
        if (currentInput.method_7960()) {
            if (this.tritium$cachedInput != null || !this.tritium$cacheMissed) {
                this.tritium$resetCache();
            }
            return 200;
        }
        class_8786<? extends class_1874> recipe = this.tritium$getCachedRecipe(currentInput);
        if (recipe == null) {
            if (!this.tritium$cacheMissed) {
                this.tritium$updateCache(level, currentInput);
                recipe = this.tritium$cachedRecipe;
            }
            if (recipe == null) {
                return 200;
            }
        }
        return ((class_1874)recipe.comp_1933()).method_8167();
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void onSetItem(int pIndex, class_1799 pStack, CallbackInfo ci) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        if (!(pIndex != 0 || this.tritium$cachedInput != null && class_1799.method_31577((class_1799)this.tritium$cachedInput, (class_1799)pStack))) {
            this.tritium$resetCache();
        }
    }

    @Inject(method={"setItems"}, at={@At(value="HEAD")})
    private void onSetItems(class_2371<class_1799> pItems, CallbackInfo ci) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        this.tritium$resetCache();
    }
}

