/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.reflex;

import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4599;
import net.minecraft.class_757;
import net.minecraft.class_759;
import net.minecraft.class_9779;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL33;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_757.class})
public abstract class ReflexSchedulerMixin {
    @Unique
    private static final int MODE_DISABLED = 0;
    @Unique
    private static final int MODE_TIMESTAMP = 1;
    @Unique
    private static final int MODE_ELAPSED = 2;
    @Unique
    private static final Logger tritium$LOGGER = LogManager.getLogger((String)"Tritium-Reflex");
    @Unique
    private static final long MAX_WAIT_NS = 2000000L;
    @Unique
    private static final long MIN_FRAME_NS = 1000000L;
    @Unique
    private static final double SMOOTH_ALPHA = 0.15;
    @Unique
    private final int[] tritium$queryIds = new int[2];
    @Unique
    private int tritium$timingMode = 0;
    @Unique
    private int tritium$queryIndex = 0;
    @Unique
    private long tritium$lastGpuDoneNs = -1L;
    @Unique
    private long tritium$lastFrameEndNs = -1L;
    @Unique
    private double tritium$smoothedDeltaNs = 0.0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void reflex$init(class_310 p_234219_, class_759 p_234220_, class_3300 p_234221_, class_4599 p_234222_, CallbackInfo ci) {
        if (GL.getCapabilities().GL_ARB_timer_query) {
            this.tritium$timingMode = 1;
            GL33.glGenQueries((int[])this.tritium$queryIds);
            tritium$LOGGER.info("Using high-precision timestamp queries");
        } else if (GL.getCapabilities().GL_EXT_timer_query || GL.getCapabilities().GL_ARB_occlusion_query) {
            this.tritium$timingMode = 2;
            GL33.glGenQueries((int[])this.tritium$queryIds);
            tritium$LOGGER.info("Using elapsed time queries (compatibility mode)");
        } else {
            tritium$LOGGER.warn("No supported GPU timing method available, Reflex disabled");
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void reflex$onCpuStart(class_9779 deltaTracker, boolean renderLevel, CallbackInfo ci) {
        long elapsed;
        long targetFrameTime;
        long remaining;
        int maxFps;
        if (!TritiumConfigBase.Rendering.Reflex.enableReflex || this.tritium$timingMode == 0) {
            return;
        }
        long cpuNow = System.nanoTime();
        long gpuDone = -1L;
        switch (this.tritium$timingMode) {
            case 1: {
                long l = this.tritium$getGpuTimestamp(cpuNow);
                break;
            }
            case 2: {
                long l = this.tritium$getGpuElapsedTime();
                break;
            }
            default: {
                long l = gpuDone = gpuDone;
            }
        }
        if (gpuDone > 0L && gpuDone < cpuNow) {
            this.tritium$lastGpuDoneNs = gpuDone;
            long cpuElapsed = cpuNow - this.tritium$lastGpuDoneNs;
            this.tritium$smoothedDeltaNs = 0.15 * (double)cpuElapsed + 0.85 * this.tritium$smoothedDeltaNs;
            long waitNs = (long)(this.tritium$smoothedDeltaNs + (double)TritiumConfigBase.Rendering.Reflex.reflexOffsetNs);
            if ((waitNs = Math.max(-2000000L, Math.min(2000000L, waitNs))) > 0L) {
                this.tritium$smartWait(cpuNow, waitNs);
            }
        }
        if ((maxFps = TritiumConfigBase.Rendering.Reflex.MAX_FPS) > 0 && this.tritium$lastFrameEndNs > 0L && (remaining = (targetFrameTime = 1000000000L / (long)maxFps) - (elapsed = cpuNow - this.tritium$lastFrameEndNs)) > 1000000L) {
            this.tritium$smartWait(cpuNow, remaining);
        }
        if (TritiumConfigBase.Rendering.Reflex.reflexDebug) {
            tritium$LOGGER.debug("Reflex stats - Mode: {}, GPU: {}ns, CPU: {}ns, Delta: {}ns", (Object)this.tritium$timingModeToString(), (Object)this.tritium$lastGpuDoneNs, (Object)this.tritium$lastFrameEndNs, (Object)this.tritium$smoothedDeltaNs);
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void reflex$onCpuEnd(class_9779 deltaTracker, boolean renderLevel, CallbackInfo ci) {
        if (this.tritium$timingMode == 0 || !TritiumConfigBase.Rendering.Reflex.enableReflex) {
            return;
        }
        switch (this.tritium$timingMode) {
            case 1: {
                GL33.glQueryCounter((int)this.tritium$queryIds[this.tritium$queryIndex], (int)36392);
                break;
            }
            case 2: {
                GL33.glBeginQuery((int)35007, (int)this.tritium$queryIds[this.tritium$queryIndex]);
                GL33.glEndQuery((int)35007);
            }
        }
        this.tritium$queryIndex ^= 1;
        this.tritium$lastFrameEndNs = System.nanoTime();
    }

    @Unique
    private long tritium$getGpuTimestamp(long cpuNow) {
        int prev = this.tritium$queryIndex ^ 1;
        if (!GL33.glIsQuery((int)this.tritium$queryIds[prev])) {
            return -1L;
        }
        int[] ready = new int[]{0};
        GL33.glGetQueryObjectiv((int)this.tritium$queryIds[prev], (int)34919, (int[])ready);
        if (ready[0] == 0) {
            return -1L;
        }
        long gpuTime = GL33.glGetQueryObjecti64((int)this.tritium$queryIds[prev], (int)34918);
        return gpuTime > 0L && gpuTime < cpuNow ? gpuTime : -1L;
    }

    @Unique
    private long tritium$getGpuElapsedTime() {
        int prev = this.tritium$queryIndex ^ 1;
        if (!GL33.glIsQuery((int)this.tritium$queryIds[prev])) {
            return -1L;
        }
        int[] ready = new int[]{0};
        GL33.glGetQueryObjectiv((int)this.tritium$queryIds[prev], (int)34919, (int[])ready);
        if (ready[0] == 0) {
            return -1L;
        }
        int[] timeNs = new int[]{0};
        GL33.glGetQueryObjectiv((int)this.tritium$queryIds[prev], (int)34918, (int[])timeNs);
        return this.tritium$lastFrameEndNs > 0L ? this.tritium$lastFrameEndNs + (long)timeNs[0] * 1000000L : -1L;
    }

    @Unique
    private void tritium$smartWait(long startTime, long waitNs) {
        long endTime = startTime + waitNs;
        while (System.nanoTime() < endTime - 100000L) {
            Thread.onSpinWait();
        }
        while (System.nanoTime() < endTime) {
            try {
                Thread.sleep(0L, 1000);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    @Unique
    private String tritium$timingModeToString() {
        return switch (this.tritium$timingMode) {
            case 1 -> "TIMESTAMP";
            case 2 -> "ELAPSED";
            default -> "DISABLED";
        };
    }
}

