/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.entity.stack.item;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin {
    @Unique
    private static final int DEFAULT_MAX_STACK = 2147483547;
    @Unique
    private int tritium$lastMergeTick = -1;

    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    public abstract void method_6979(class_1799 var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        class_1542 self = (class_1542)this;
        if (this.tritium$shouldAttemptMerge(self)) {
            this.tritium$lastMergeTick = (int)self.method_37908().method_8510();
            this.tritium$tryMergeItems(self);
        }
    }

    @Inject(method={"setItem"}, at={@At(value="TAIL")})
    private void onSetItem(class_1799 stack, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        class_1542 self = (class_1542)this;
        this.tritium$updateStackDisplay(self);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private void onConstructor(class_1937 level, double x, double y, double z, class_1799 stack, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        class_1542 self = (class_1542)this;
        this.tritium$updateStackDisplay(self);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="TAIL")})
    private void onConstructorWithVelocity(class_1937 level, double x, double y, double z, class_1799 stack, double dx, double dy, double dz, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        class_1542 self = (class_1542)this;
        this.tritium$updateStackDisplay(self);
    }

    @Unique
    private boolean tritium$shouldProcess() {
        return TritiumConfigBase.Entities.EntityStacking.enable;
    }

    @Unique
    private boolean tritium$shouldAttemptMerge(class_1542 self) {
        long gameTime = self.method_37908().method_8510();
        return this.tritium$lastMergeTick == -1 || gameTime - (long)this.tritium$lastMergeTick >= (long)TritiumConfigBase.Entities.EntityStacking.mergeCooldown;
    }

    @Unique
    private void tritium$tryMergeItems(class_1542 self) {
        if (!TritiumConfigBase.Entities.EntityStacking.enable) {
            return;
        }
        class_1799 stack = self.method_6983();
        int maxStack = this.tritium$getEffectiveMaxStackSize();
        if (stack.method_7947() >= maxStack) {
            return;
        }
        List<class_1542> nearby = this.tritium$findMergeableItems(self);
        if (nearby.isEmpty()) {
            return;
        }
        this.tritium$performMerge(self, stack, maxStack, nearby);
    }

    @Unique
    private int tritium$getEffectiveMaxStackSize() {
        int configMax = TritiumConfigBase.Entities.EntityStacking.maxStackSize;
        return configMax > 0 ? configMax : 2147483547;
    }

    @Unique
    private List<class_1542> tritium$findMergeableItems(class_1542 self) {
        double mergeDistance = TritiumConfigBase.Entities.EntityStacking.mergeDistance;
        int listMode = TritiumConfigBase.Entities.EntityStacking.listMode;
        List<String> itemList = TritiumConfigBase.Entities.EntityStacking.itemList;
        List nearby = self.method_37908().method_8390(class_1542.class, self.method_5829().method_1014(mergeDistance), e -> this.tritium$isValidMergeTarget(self, (class_1542)e, listMode, (List<? extends String>)itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((class_1542)self).method_5858(arg_0)));
        return nearby;
    }

    @Unique
    private void tritium$performMerge(class_1542 self, class_1799 stack, int maxStack, List<class_1542> nearby) {
        int remainingSpace = maxStack - stack.method_7947();
        for (class_1542 other : nearby) {
            if (remainingSpace <= 0) break;
            class_1799 otherStack = other.method_6983();
            int transfer = Math.min(otherStack.method_7947(), remainingSpace);
            stack.method_7933(transfer);
            self.method_6979(stack);
            self.method_6976();
            this.tritium$handleOtherStackAfterTransfer(other, otherStack, transfer);
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void tritium$handleOtherStackAfterTransfer(class_1542 other, class_1799 otherStack, int transfer) {
        if (otherStack.method_7947() == transfer) {
            other.method_31472();
        } else {
            otherStack.method_7934(transfer);
            other.method_6979(otherStack);
            this.tritium$updateStackDisplay(other);
        }
    }

    @Unique
    private void tritium$updateStackDisplay(class_1542 entity) {
        if (!TritiumConfigBase.Entities.EntityStacking.enable || !TritiumConfigBase.Entities.EntityStacking.showStackCount) {
            this.tritium$clearDisplay(entity);
            return;
        }
        class_1799 stack = entity.method_6983();
        if (stack.method_7947() > 1) {
            this.tritium$setStackCountDisplay(entity, stack.method_7947());
        } else {
            this.tritium$clearDisplay(entity);
        }
    }

    @Unique
    private void tritium$setStackCountDisplay(class_1542 entity, int count) {
        String currentText;
        class_2561 currentName = entity.method_5797();
        if (currentName != null && (currentText = currentName.getString()).startsWith("\u00d7") && currentText.length() > 1) {
            try {
                int currentCount = Integer.parseInt(currentText.substring(1));
                if (currentCount == count) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        class_5250 countText = class_2561.method_43470((String)("\u00d7" + count)).method_27692(class_124.field_1077).method_27692(class_124.field_1067);
        entity.method_5665((class_2561)countText);
        entity.method_5880(true);
    }

    @Unique
    private void tritium$clearDisplay(class_1542 entity) {
        entity.method_5665(null);
        entity.method_5880(false);
    }

    @Unique
    private boolean tritium$isValidMergeTarget(class_1542 self, class_1542 other, int listMode, List<? extends String> itemList) {
        class_1799 otherStack;
        if (self == other || other.method_31481()) {
            return false;
        }
        class_1799 selfStack = self.method_6983();
        return this.tritium$areItemsCompletelyIdentical(selfStack, otherStack = other.method_6983()) && this.tritium$isMergeAllowed(otherStack, listMode, itemList) && (!TritiumConfigBase.Entities.EntityStacking.lockMaxedStacks || otherStack.method_7947() < this.tritium$getEffectiveMaxStackSize());
    }

    @Unique
    private boolean tritium$areItemsCompletelyIdentical(class_1799 a, class_1799 b) {
        if (!class_1799.method_7984((class_1799)a, (class_1799)b)) {
            return false;
        }
        if (!class_1799.method_31577((class_1799)a, (class_1799)b)) {
            return false;
        }
        class_9304 enchantmentsA = (class_9304)a.method_57824(class_9334.field_49633);
        class_9304 enchantmentsB = (class_9304)b.method_57824(class_9334.field_49633);
        if (enchantmentsA != null && enchantmentsB != null ? !enchantmentsA.equals((Object)enchantmentsB) : enchantmentsA != enchantmentsB) {
            return false;
        }
        if (a.method_57826(class_9334.field_49631) && b.method_57826(class_9334.field_49631) ? !Objects.requireNonNull((class_2561)a.method_57824(class_9334.field_49631)).equals(b.method_57824(class_9334.field_49631)) : a.method_57826(class_9334.field_49631) != b.method_57826(class_9334.field_49631)) {
            return false;
        }
        return Arrays.equals(a.method_40133().toArray(), b.method_40133().toArray());
    }

    @Unique
    private boolean tritium$isMergeAllowed(class_1799 stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 == inList;
    }
}

