/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import org.craftamethyst.tritium.cull.LeafCulling;

public final class BlockFaceOcclusionCuller {
    private static final AtomicBoolean FALLBACK_MODE = new AtomicBoolean(false);
    private static final int TRACE_DISTANCE = 16;
    private static final double SAMPLE_OFFSET = 0.2;
    private static final Object2BooleanOpenHashMap<Key> BLOCK_CACHE = new Object2BooleanOpenHashMap(16000);
    private static final ConcurrentMap<Key, CompletableFuture<Boolean>> INFLIGHT = new ConcurrentHashMap<Key, CompletableFuture<Boolean>>();
    private static ExecutorService tracerPool;
    private static ScheduledExecutorService timeoutChecker;
    private static final AtomicInteger PENDING;
    private static long lastCacheCleanup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCullBlockFace(class_1922 level, class_2338 pos, class_2350 face) {
        if (FALLBACK_MODE.get()) {
            return LeafCulling.checkSimpleConnection(level, pos.method_10093(face), face);
        }
        long now = System.currentTimeMillis();
        if (now - lastCacheCleanup > 1000L) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap) {
                BLOCK_CACHE.clear();
            }
            lastCacheCleanup = now;
        }
        Key key = new Key(System.identityHashCode(level), pos.method_10063(), (byte)face.ordinal());
        Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
        synchronized (object2BooleanOpenHashMap) {
            if (BLOCK_CACHE.containsKey((Object)key)) {
                return BLOCK_CACHE.getBoolean((Object)key);
            }
        }
        class_2338 adjacentPos = pos.method_10093(face);
        class_2680 neighbor = level.method_8320(adjacentPos);
        if (neighbor.method_26215()) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap2 = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap2) {
                BLOCK_CACHE.put((Object)key, false);
            }
            return false;
        }
        if (neighbor.method_26206(level, adjacentPos, face.method_10153()) || LeafCulling.checkSimpleConnection(level, adjacentPos)) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap3 = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap3) {
                BLOCK_CACHE.put((Object)key, true);
            }
            return true;
        }
        BlockFaceOcclusionCuller.scheduleTrace(level, pos, face, key);
        return false;
    }

    private static void scheduleTrace(class_1922 level, class_2338 pos, class_2350 face, Key key) {
        INFLIGHT.computeIfAbsent(key, k -> {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            Runnable work = () -> {
                try {
                    class_243 dir;
                    class_243 endCenter;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    class_243 startCenter = BlockFaceOcclusionCuller.getFaceCenter(pos, face);
                    boolean anyVisible = BlockFaceOcclusionCuller.traceVisibilityMultiSample(startCenter, endCenter = startCenter.method_1019((dir = new class_243((double)face.method_10148(), (double)face.method_10164(), (double)face.method_10165())).method_1021(16.0)), level, face);
                    boolean shouldCull = !anyVisible;
                    future.complete(shouldCull);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
                finally {
                    PENDING.decrementAndGet();
                }
            };
            if (PENDING.incrementAndGet() > 4096) {
                PENDING.decrementAndGet();
                future.complete(false);
            } else {
                Future<?> task = tracerPool.submit(work);
                timeoutChecker.schedule(() -> {
                    if (!future.isDone()) {
                        task.cancel(true);
                        future.complete(false);
                    }
                }, 25L, TimeUnit.MILLISECONDS);
            }
            future.whenComplete((res, err) -> {
                block10: {
                    try {
                        if (err != null) {
                            FALLBACK_MODE.set(true);
                            boolean fb = LeafCulling.checkSimpleConnection(level, pos.method_10093(face));
                            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
                            synchronized (object2BooleanOpenHashMap) {
                                BLOCK_CACHE.put((Object)key, fb);
                                break block10;
                            }
                        }
                        Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
                        synchronized (object2BooleanOpenHashMap) {
                            BLOCK_CACHE.put((Object)key, res);
                        }
                    }
                    finally {
                        INFLIGHT.remove(key);
                    }
                }
            });
            return future;
        });
    }

    private static boolean traceVisibilityMultiSample(class_243 centerStart, class_243 centerEnd, class_1922 level, class_2350 face) {
        class_243[] offsets;
        for (class_243 off : offsets = BlockFaceOcclusionCuller.sampleOffsets(face)) {
            class_243 e;
            if (Thread.interrupted()) {
                return true;
            }
            class_243 s = centerStart.method_1019(off);
            if (!BlockFaceOcclusionCuller.traceVisibility(s, e = centerEnd.method_1019(off), level)) continue;
            return true;
        }
        return false;
    }

    private static boolean traceVisibility(class_243 start, class_243 end, class_1922 level) {
        class_243 direction = end.method_1020(start);
        double distance = direction.method_1033();
        if (distance < 0.001) {
            return true;
        }
        direction = direction.method_1029();
        double stepSize = Math.min(0.25, Math.max(0.0625, distance / 32.0));
        int maxSteps = (int)Math.min(256.0, Math.ceil(distance / stepSize) + 2.0);
        class_2338.class_2339 mpos = new class_2338.class_2339();
        class_243 current = start;
        int steps = 0;
        while (steps++ < maxSteps && current.method_1022(start) < distance) {
            if (Thread.interrupted()) {
                return true;
            }
            mpos.method_10102(current.field_1352, current.field_1351, current.field_1350);
            class_2680 state = level.method_8320((class_2338)mpos);
            if (!state.method_26215() && !state.method_26201(level, (class_2338)mpos).method_1110() && state.method_26220(level, (class_2338)mpos).method_1107().method_996((class_2338)mpos).method_1006(current)) {
                return false;
            }
            current = current.method_1019(direction.method_1021(stepSize));
        }
        return true;
    }

    private static class_243[] sampleOffsets(class_2350 face) {
        switch (face) {
            case field_11036: 
            case field_11033: {
                return new class_243[]{class_243.field_1353, new class_243(0.2, 0.0, 0.0), new class_243(-0.2, 0.0, 0.0), new class_243(0.0, 0.0, 0.2), new class_243(0.0, 0.0, -0.2)};
            }
            case field_11043: 
            case field_11035: {
                return new class_243[]{class_243.field_1353, new class_243(0.2, 0.0, 0.0), new class_243(-0.2, 0.0, 0.0), new class_243(0.0, 0.2, 0.0), new class_243(0.0, -0.2, 0.0)};
            }
        }
        return new class_243[]{class_243.field_1353, new class_243(0.0, 0.2, 0.0), new class_243(0.0, -0.2, 0.0), new class_243(0.0, 0.0, 0.2), new class_243(0.0, 0.0, -0.2)};
    }

    private static class_243 getFaceCenter(class_2338 pos, class_2350 face) {
        return new class_243((double)pos.method_10263() + 0.5 + (double)face.method_10148() * 0.501, (double)pos.method_10264() + 0.5 + (double)face.method_10164() * 0.501, (double)pos.method_10260() + 0.5 + (double)face.method_10165() * 0.501);
    }

    public static boolean isInFallbackMode() {
        return FALLBACK_MODE.get();
    }

    private static synchronized void initExecutors() {
        if (tracerPool == null) {
            int cpus = Math.max(2, Runtime.getRuntime().availableProcessors());
            tracerPool = new ThreadPoolExecutor(Math.max(1, cpus / 4), Math.max(2, cpus / 2), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(4096), new NamedThreadFactory("Tritium-occl-trace", true), new ThreadPoolExecutor.DiscardPolicy());
        }
        if (timeoutChecker == null) {
            timeoutChecker = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Tritium-occl-timeout", true));
        }
    }

    static {
        PENDING = new AtomicInteger();
        lastCacheCleanup = System.currentTimeMillis();
        BlockFaceOcclusionCuller.initExecutors();
    }

    private record Key(int levelId, long pos, byte face) {
    }

    private static final class NamedThreadFactory
    implements ThreadFactory {
        private final String baseName;
        private final boolean daemon;
        private final AtomicInteger idx = new AtomicInteger(1);

        private NamedThreadFactory(String baseName, boolean daemon) {
            this.baseName = Objects.requireNonNull(baseName);
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.baseName + "-" + this.idx.getAndIncrement());
            t.setDaemon(this.daemon);
            t.setPriority(4);
            return t;
        }
    }
}

