/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

final class SingleTaskLane {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final Thread thread;
    private final AtomicBoolean running = new AtomicBoolean(true);

    SingleTaskLane(String name) {
        this.thread = new Thread(this::loop, name);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    Future<?> submit(Runnable r) {
        if (!this.running.get()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture f = new CompletableFuture();
        this.queue.add(() -> {
            try {
                r.run();
                f.complete(null);
            }
            catch (Throwable t) {
                f.completeExceptionally(t);
            }
        });
        return f;
    }

    void shutdown() {
        this.running.set(false);
        this.thread.interrupt();
    }

    private void loop() {
        while (this.running.get()) {
            try {
                Runnable task = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                if (task == null) continue;
                task.run();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

