/*
 * Decompiled with CFR 0.152.
 */
package me.zcraft.tconfig.config;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import me.zcraft.tconfig.annotation.ConfigVersion;
import me.zcraft.tconfig.config.ConfigParser;
import org.craftamethyst.tritium.TritiumCommon;

public class ConfigMigration {
    public static boolean migrateConfig(Path configPath, ConfigParser parser, Class<?> configClass) {
        try {
            int currentVersion = ConfigMigration.getCurrentConfigVersion(configClass);
            int fileVersion = ConfigMigration.detectConfigVersion(parser);
            if (fileVersion < currentVersion) {
                TritiumCommon.LOG.info("Migrating config from version {} to {}", (Object)fileVersion, (Object)currentVersion);
                return ConfigMigration.performMigration(configPath, parser, fileVersion, currentVersion, configClass);
            }
            return true;
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Config migration failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static int getCurrentConfigVersion(Class<?> configClass) {
        try {
            ConfigVersion version = configClass.getAnnotation(ConfigVersion.class);
            return version != null ? version.value() : 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private static int detectConfigVersion(ConfigParser parser) {
        if (parser.hasKey("config_version")) {
            return parser.getInt("config_version", 1).get();
        }
        return 1;
    }

    private static boolean performMigration(Path configPath, ConfigParser parser, int fromVersion, int toVersion, Class<?> configClass) throws IOException {
        HashMap<String, String> migratedValues = new HashMap<String, String>(parser.configValues);
        try {
            for (int version = fromVersion; version < toVersion; ++version) {
                if (ConfigMigration.migrateFromVersion(migratedValues, version, configClass)) continue;
                return false;
            }
            migratedValues.put("config_version", String.valueOf(toVersion));
            StringBuilder newConfig = new StringBuilder();
            newConfig.append("# Configuration\n");
            newConfig.append("# Migrated from version ").append(fromVersion).append(" to ").append(toVersion).append("\n");
            newConfig.append("config_version = ").append(toVersion).append("\n\n");
            for (Map.Entry entry : migratedValues.entrySet()) {
                if (((String)entry.getKey()).equals("config_version")) continue;
                newConfig.append((String)entry.getKey()).append(" = ").append((String)entry.getValue()).append("\n");
            }
            Files.write(configPath, newConfig.toString().getBytes(), new OpenOption[0]);
            TritiumCommon.LOG.info("Config migration completed successfully");
            return true;
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Migration failed: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean migrateFromVersion(Map<String, String> values, int fromVersion, Class<?> configClass) {
        try {
            String methodName = "migrateFromV" + fromVersion;
            Method migrationMethod = configClass.getMethod(methodName, Map.class);
            migrationMethod.invoke(null, values);
            TritiumCommon.LOG.debug("Applied migration from version {}", (Object)fromVersion);
            return true;
        }
        catch (NoSuchMethodException e) {
            return ConfigMigration.applyDefaultMigration(values, fromVersion);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to apply custom migration for version {}: {}", (Object)fromVersion, (Object)e.getMessage());
            return false;
        }
    }

    private static boolean applyDefaultMigration(Map<String, String> values, int fromVersion) {
        try {
            switch (fromVersion) {
                case 1: {
                    ConfigMigration.migrateV1toV2(values);
                    break;
                }
                case 2: {
                    ConfigMigration.migrateV2toV3(values);
                }
            }
            return true;
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Default migration failed for version {}: {}", (Object)fromVersion, (Object)e.getMessage());
            return false;
        }
    }

    private static void migrateV1toV2(Map<String, String> values) {
        Map<String, String> migrations = Map.of("rendering.enableCulling", "rendering.entityCulling.enableCulling", "rendering.enableEntityCulling", "rendering.entityCulling.enableEntityCulling");
        ConfigMigration.applyMigrations(values, migrations);
    }

    private static void migrateV2toV3(Map<String, String> values) {
        Map<String, String> migrations = Map.of("old.setting", "new.setting");
        ConfigMigration.applyMigrations(values, migrations);
    }

    private static void applyMigrations(Map<String, String> values, Map<String, String> migrations) {
        for (Map.Entry<String, String> migration : migrations.entrySet()) {
            String oldKey = migration.getKey();
            String newKey = migration.getValue();
            if (!values.containsKey(oldKey) || values.containsKey(newKey)) continue;
            values.put(newKey, values.get(oldKey));
            values.remove(oldKey);
            TritiumCommon.LOG.debug("Migrated config key: {} -> {}", (Object)oldKey, (Object)newKey);
        }
    }
}

