/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.craftamethyst.tritium.cull.CullCache;
import org.craftamethyst.tritium.cull.OcclusionProvider;
import org.craftamethyst.tritium.cull.iface.BlockEntityVisibility;
import org.craftamethyst.tritium.cull.iface.EntityVisibility;
import tritium.libs.com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import tritium.libs.com.logisticscraft.occlusionculling.util.Vec3d;

public class AABBCullingManager {
    private static final double HITBOX_LIMIT = 10.0;
    private static final double MANHATTAN_THRESHOLD = 1.732;
    private static final long CAMERA_UPDATE_INTERVAL = 50L;
    private static final long DISTANCE_UPDATE_INTERVAL = 1000L;
    private static final double RESET_DISTANCE_THRESHOLD = 2.0;
    private static final long MIN_RESET_INTERVAL = 1000L;
    private final OcclusionCullingInstance occlusionCulling;
    private final CullCache cullCache = new CullCache();
    private final class_310 mc;
    private final AABBOBJ reusableAABB = new AABBOBJ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final Vec3d reusableAabbMin = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d reusableAabbMax = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d reusableCamera = new Vec3d(0.0, 0.0, 0.0);
    private class_243 cachedCameraPos = class_243.field_1353;
    private double cachedCullingDistance = 128.0;
    private long lastCameraUpdate = 0L;
    private long lastDistanceUpdate = 0L;
    private class_243 lastResetCameraPos = class_243.field_1353;
    private long lastResetTime = 0L;

    public AABBCullingManager() {
        this.mc = class_310.method_1551();
        this.occlusionCulling = new OcclusionCullingInstance(64, new OcclusionProvider());
    }

    public boolean shouldCullEntity(class_1297 entity) {
        EntityVisibility cullable;
        if (this.isPlayerSprinting()) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        if (this.mc.field_1687 == null) {
            return false;
        }
        CullCache.CullResult cached = this.cullCache.checkEntity(entity);
        if (cached.isCached()) {
            return cached.isCulled();
        }
        if (entity instanceof EntityVisibility && (cullable = (EntityVisibility)entity).tritium$isForcedVisible()) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        if (!this.needsDetailedEntityCheck(entity)) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        class_243 cameraPos = this.getCachedCameraPos();
        double cullingDistance = this.getCachedCullingDistance();
        if (this.isWithinDistanceOptimized(entity.method_33571(), cameraPos, cullingDistance)) {
            this.cullCache.cacheEntity(entity, true);
            return true;
        }
        class_238 boundingBox = entity.method_5829();
        if (this.isLargeEntity(boundingBox)) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        boolean visible = this.performOcclusionCheck(boundingBox, cameraPos);
        boolean shouldCull = !visible;
        this.cullCache.cacheEntity(entity, shouldCull);
        return shouldCull;
    }

    public boolean shouldCullBlockEntity(class_2586 blockEntity) {
        BlockEntityVisibility cullable;
        if (this.isPlayerSprinting()) {
            return false;
        }
        if (blockEntity == null) {
            return false;
        }
        if (this.mc.field_1687 == null) {
            return false;
        }
        CullCache.CullResult cached = this.cullCache.checkBlockEntity(blockEntity);
        if (cached.isCached()) {
            return cached.isCulled();
        }
        if (blockEntity instanceof BlockEntityVisibility && (cullable = (BlockEntityVisibility)blockEntity).tritium$isForcedVisible()) {
            this.cullCache.cacheBlockEntity(blockEntity, false);
            return false;
        }
        class_243 cameraPos = this.getCachedCameraPos();
        double cullingDistance = this.getCachedCullingDistance();
        if (this.isWithinDistanceOptimized(blockEntity.method_11016().method_46558(), cameraPos, cullingDistance)) {
            this.cullCache.cacheBlockEntity(blockEntity, true);
            return true;
        }
        class_2338 pos = blockEntity.method_11016();
        this.reusableAABB.set(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1);
        boolean visible = this.performOcclusionCheck(this.reusableAABB, cameraPos);
        boolean shouldCull = !visible;
        this.cullCache.cacheBlockEntity(blockEntity, shouldCull);
        return shouldCull;
    }

    private boolean needsDetailedEntityCheck(class_1297 entity) {
        class_1531 armorStand;
        if (entity.method_5767()) {
            return false;
        }
        if (entity == this.mc.method_1560()) {
            return false;
        }
        if (entity == this.mc.field_1724) {
            return false;
        }
        if (entity.method_7325()) {
            return false;
        }
        if (entity.method_5782()) {
            return false;
        }
        if (entity.method_5765()) {
            return false;
        }
        return !(entity instanceof class_1531) || !(armorStand = (class_1531)entity).method_6912();
    }

    private boolean isWithinDistanceOptimized(class_243 entityPos, class_243 cameraPos, double distance) {
        double manhattan = Math.abs(entityPos.field_1352 - cameraPos.field_1352) + Math.abs(entityPos.field_1351 - cameraPos.field_1351) + Math.abs(entityPos.field_1350 - cameraPos.field_1350);
        if (manhattan > distance * 1.732) {
            return true;
        }
        double dx = entityPos.field_1352 - cameraPos.field_1352;
        double dy = entityPos.field_1351 - cameraPos.field_1351;
        double dz = entityPos.field_1350 - cameraPos.field_1350;
        double distanceSq = dx * dx + dy * dy + dz * dz;
        return !(distanceSq <= distance * distance);
    }

    private boolean performOcclusionCheck(class_238 boundingBox, class_243 cameraPos) {
        this.reusableAabbMin.set(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
        this.reusableAabbMax.set(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
        this.reusableCamera.set(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
        return this.occlusionCulling.isAABBVisible(this.reusableAabbMin, this.reusableAabbMax, this.reusableCamera);
    }

    private boolean performOcclusionCheck(AABBOBJ boundingBox, class_243 cameraPos) {
        this.reusableAabbMin.set(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        this.reusableAabbMax.set(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        this.reusableCamera.set(cameraPos.field_1352, cameraPos.field_1351, cameraPos.field_1350);
        return this.occlusionCulling.isAABBVisible(this.reusableAabbMin, this.reusableAabbMax, this.reusableCamera);
    }

    private boolean isLargeEntity(class_238 boundingBox) {
        return boundingBox.method_17939() > 10.0 || boundingBox.method_17940() > 10.0 || boundingBox.method_17941() > 10.0;
    }

    private class_243 getCachedCameraPos() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCameraUpdate > 50L) {
            class_4184 mainCamera = this.mc.field_1773.method_19418();
            this.cachedCameraPos = mainCamera.method_19326();
            this.lastCameraUpdate = currentTime;
        }
        return this.cachedCameraPos;
    }

    private double getCachedCullingDistance() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDistanceUpdate > 1000L) {
            this.cachedCullingDistance = this.mc.field_1687 == null ? 128.0 : (double)(this.mc.field_1687.method_39024() * 16) * 1.1;
            this.lastDistanceUpdate = currentTime;
        }
        return this.cachedCullingDistance;
    }

    public void updateCameraPosition() {
        class_243 currentCameraPos = this.getCachedCameraPos();
        long currentTime = System.currentTimeMillis();
        boolean shouldReset = false;
        if (this.lastResetCameraPos == class_243.field_1353) {
            shouldReset = true;
        } else {
            double distanceMoved = currentCameraPos.method_1022(this.lastResetCameraPos);
            if (distanceMoved > 2.0) {
                shouldReset = true;
            }
        }
        if (currentTime - this.lastResetTime > 1000L) {
            shouldReset = true;
        }
        if (shouldReset) {
            this.occlusionCulling.resetCache();
            this.lastResetCameraPos = currentCameraPos;
            this.lastResetTime = currentTime;
        }
        this.lastCameraUpdate = 0L;
    }

    public void dispose() {
        this.cullCache.clear();
        this.lastResetCameraPos = class_243.field_1353;
        this.lastResetTime = 0L;
    }

    private boolean isPlayerSprinting() {
        return this.mc.field_1724 != null && this.mc.field_1724.method_5624();
    }

    public double getCurrentCullingDistance() {
        return this.cachedCullingDistance;
    }

    public OcclusionCullingInstance getOcclusionCulling() {
        return this.occlusionCulling;
    }

    public void forceResetCache() {
        this.occlusionCulling.resetCache();
        this.lastResetCameraPos = this.getCachedCameraPos();
        this.lastResetTime = System.currentTimeMillis();
    }

    public static class AABBOBJ {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;

        public AABBOBJ(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.set(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public void set(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public double getXsize() {
            return this.maxX - this.minX;
        }

        public double getYsize() {
            return this.maxY - this.minY;
        }

        public double getZsize() {
            return this.maxZ - this.minZ;
        }
    }
}

