/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class AsyncWorldSaveMixin {
    @Unique
    private static final ExecutorService SAVE_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Tritium-Async-World-Save");
        thread.setDaemon(true);
        return thread;
    });
    @Shadow
    private volatile boolean field_4544;

    @Shadow
    public abstract Iterable<class_3218> method_3738();

    @Inject(method={"saveAllChunks(ZZZ)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSaveAllChunks(boolean suppressLogs, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> cir) {
        if (!TritiumConfigBase.ServerPerformance.asyncWorldSave) {
            return;
        }
        if (!this.field_4544 && forced) {
            TritiumCommon.LOG.info("Using async world save on server shutdown");
            CompletableFuture<Void> saveFuture = CompletableFuture.runAsync(() -> {
                try {
                    for (class_3218 level : this.method_3738()) {
                        TritiumCommon.LOG.info("Async saving world: {}", (Object)level.method_27983().method_29177());
                        level.method_14176(null, flush, level.field_13957);
                    }
                    TritiumCommon.LOG.info("Async world save completed");
                }
                catch (Exception e) {
                    TritiumCommon.LOG.error("Error during async world save", (Throwable)e);
                }
            }, SAVE_EXECUTOR);
            int timeout = TritiumConfigBase.ServerPerformance.asyncWorldSaveTimeoutSeconds;
            try {
                saveFuture.get(timeout, TimeUnit.SECONDS);
                cir.setReturnValue((Object)true);
            }
            catch (Exception e) {
                TritiumCommon.LOG.error("Async world save timeout or error", (Throwable)e);
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"stopServer()V"}, at={@At(value="HEAD")})
    private void onStopServer(CallbackInfo ci) {
        TritiumCommon.LOG.info("Server stopping, preparing async world save");
    }

    @Inject(method={"stopServer()V"}, at={@At(value="TAIL")})
    private void afterStopServer(CallbackInfo ci) {
        SAVE_EXECUTOR.shutdown();
        try {
            if (!SAVE_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS)) {
                SAVE_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            SAVE_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

