/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.gpu;

import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import java.nio.ByteBuffer;
import org.craftamethyst.tritium.TritiumCommon;
import org.lwjgl.opengl.ARBBufferStorage;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GLCapabilities;

public final class GpuPlusGL {
    private static final Int2BooleanOpenHashMap bufferImmutable = new Int2BooleanOpenHashMap();
    private static final Int2LongOpenHashMap bufferSizes = new Int2LongOpenHashMap();
    private static boolean initialized = false;
    private static boolean supportsBufferStorage = false;
    private static boolean supportsDSA = false;

    private GpuPlusGL() {
    }

    private static void ensureCaps() {
        if (initialized) {
            return;
        }
        GLCapabilities caps = GL.getCapabilities();
        if (caps == null) {
            TritiumCommon.LOG.warn("[Tritium-GPU Plus] GL capabilities queried before context; disabling advanced GL features.");
            initialized = true;
            return;
        }
        supportsBufferStorage = caps.GL_ARB_buffer_storage;
        supportsDSA = caps.OpenGL45;
        TritiumCommon.LOG.info("[Tritium-GPU Plus] Caps - BufferStorage: {} DSA: {}", (Object)supportsBufferStorage, (Object)supportsDSA);
        initialized = true;
    }

    public static boolean supportsBufferStorage() {
        GpuPlusGL.ensureCaps();
        return supportsBufferStorage;
    }

    public static boolean supportsDSA() {
        GpuPlusGL.ensureCaps();
        return supportsDSA;
    }

    public static void bufferStorageOrData(int target, long size, int usage, int storageFlags) {
        GpuPlusGL.ensureCaps();
        if (supportsBufferStorage) {
            ARBBufferStorage.glBufferStorage((int)target, (long)size, (int)storageFlags);
        } else {
            GL15.glBufferData((int)target, (long)size, (int)usage);
        }
    }

    public static void bufferStorageOrData(int target, ByteBuffer data, int usage, int storageFlags) {
        GpuPlusGL.ensureCaps();
        if (supportsBufferStorage) {
            ARBBufferStorage.glBufferStorage((int)target, (ByteBuffer)data, (int)storageFlags);
        } else {
            GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        }
    }

    public static void uploadBoundBuffer(int target, ByteBuffer data, int usage, int storageFlags) {
        GpuPlusGL.ensureCaps();
        if (data == null) {
            return;
        }
        int bindingEnum = switch (target) {
            case 34962 -> 34964;
            case 34963 -> 34965;
            default -> 34964;
        };
        int buffer = GL11.glGetInteger((int)bindingEnum);
        if (buffer == 0) {
            GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
            return;
        }
        GpuPlusGL.uploadBuffer(target, buffer, data, usage, storageFlags);
    }

    public static void uploadBuffer(int target, int buffer, ByteBuffer data, int usage, int storageFlags) {
        GpuPlusGL.ensureCaps();
        if (data == null) {
            return;
        }
        int size = data.remaining();
        GL15.glBindBuffer((int)target, (int)buffer);
        GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        bufferSizes.put(buffer, (long)size);
        bufferImmutable.put(buffer, false);
    }

    public static int createTexture(int target) {
        GpuPlusGL.ensureCaps();
        if (supportsDSA) {
            int[] tmp = new int[1];
            GL45.glCreateTextures((int)target, (int[])tmp);
            return tmp[0];
        }
        return GL11.glGenTextures();
    }

    public static void textureStorage2D(int texture, int target, int levels, int internalFormat, int width, int height) {
        GpuPlusGL.ensureCaps();
        if (supportsDSA) {
            GL45.glTextureStorage2D((int)texture, (int)levels, (int)internalFormat, (int)width, (int)height);
            return;
        }
        GL11.glBindTexture((int)target, (int)texture);
        for (int level = 0; level < levels; ++level) {
            int w = Math.max(1, width >> level);
            int h = Math.max(1, height >> level);
            GL11.glTexImage2D((int)target, (int)level, (int)internalFormat, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        }
    }

    public static void textureParameteri(int texture, int target, int pname, int param) {
        GpuPlusGL.ensureCaps();
        if (supportsDSA) {
            GL45.glTextureParameteri((int)texture, (int)pname, (int)param);
            return;
        }
        GL11.glBindTexture((int)target, (int)texture);
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public static void namedBufferStorage(int buffer, long size, int storageFlags, int usageFallback) {
        GpuPlusGL.ensureCaps();
        if (supportsDSA) {
            GL45.glNamedBufferStorage((int)buffer, (long)size, (int)storageFlags);
            return;
        }
        GL15.glBindBuffer((int)34962, (int)buffer);
        if (supportsBufferStorage) {
            ARBBufferStorage.glBufferStorage((int)34962, (long)size, (int)storageFlags);
        } else {
            GL15.glBufferData((int)34962, (long)size, (int)usageFallback);
        }
    }
}

