/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.culling;

import net.minecraft.class_2586;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_824;
import net.minecraft.class_827;
import org.craftamethyst.tritium.client.TritiumClient;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.cull.CullCache;
import org.craftamethyst.tritium.cull.iface.BlockEntityVisibility;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_824.class})
public abstract class BlockEntityRenderDispatcherMixin {
    @Shadow
    public abstract <E extends class_2586> class_827<E> method_3550(E var1);

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private <E extends class_2586> void tritium$earlyCullingCheck(E blockEntity, float partialTicks, class_4587 pose, class_4597 buffer, CallbackInfo ci) {
        CullCache.CullResult cached;
        if (!TritiumConfigBase.Rendering.EntityCulling.enableBlockEntityCulling) {
            return;
        }
        TritiumClient client = TritiumClient.instance;
        if (client == null || !(blockEntity instanceof BlockEntityVisibility)) {
            return;
        }
        BlockEntityVisibility cullable = (BlockEntityVisibility)blockEntity;
        if (client.getCullCache() != null && (cached = client.getCullCache().checkBlockEntity(blockEntity)).isCached() && cached.isCulled()) {
            ci.cancel();
            return;
        }
        if (cullable.tritium$isForcedVisible()) {
            return;
        }
        class_827<E> renderer = this.method_3550(blockEntity);
        if (renderer != null && renderer.method_3563(blockEntity)) {
            return;
        }
        if (client.shouldSkipBlockEntity(blockEntity)) {
            ci.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderDispatcher;getRenderer(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", shift=At.Shift.AFTER)}, cancellable=true)
    private <E extends class_2586> void tritium$skipCulledBlockEntity(E blockEntity, float partialTicks, class_4587 pose, class_4597 buffer, CallbackInfo ci) {
        if (!TritiumConfigBase.Rendering.EntityCulling.enableBlockEntityCulling) {
            return;
        }
        TritiumClient client = TritiumClient.instance;
        if (client == null || !(blockEntity instanceof BlockEntityVisibility)) {
            return;
        }
        BlockEntityVisibility cullable = (BlockEntityVisibility)blockEntity;
        class_827<E> renderer = this.method_3550(blockEntity);
        if (renderer != null && renderer.method_3563(blockEntity)) {
            return;
        }
        if (!cullable.tritium$isForcedVisible() && client.shouldSkipBlockEntity(blockEntity)) {
            ci.cancel();
        }
    }
}

