/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.octree;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_238;
import net.minecraft.class_265;

public class BoxOctree {
    private static final int MAX_DEPTH = 6;
    private static final int MIN_SIZE = 16;
    private static final int MAX_OBJECTS_PER_NODE = 8;
    private final OctreeNode root;
    private final class_238 bounds;

    public BoxOctree(class_238 bounds) {
        this.bounds = bounds;
        this.root = new OctreeNode(bounds, 0);
    }

    public void addShape(class_265 shape, Object owner) {
        class_238 shapeBounds = shape.method_1107();
        this.root.addObject(new OctreeObject(shapeBounds, shape, owner));
    }

    public boolean intersects(class_238 box) {
        return this.root.intersects(box);
    }

    public boolean intersects(class_265 shape) {
        return this.root.intersects(shape.method_1107());
    }

    public void getIntersectingShapes(class_238 box, Consumer<class_265> consumer) {
        this.root.getIntersectingObjects(box, obj -> consumer.accept(obj.shape));
    }

    public void getNearbyShapes(class_238 box, Consumer<class_265> consumer, double maxDistance) {
        class_238 expandedBox = box.method_1014(maxDistance);
        this.root.getIntersectingObjects(expandedBox, obj -> consumer.accept(obj.shape));
    }

    public void clear() {
        this.root.clear();
    }

    private static class OctreeNode {
        private final class_238 bounds;
        private final int depth;
        private final List<OctreeObject> objects = new ArrayList<OctreeObject>();
        private OctreeNode[] children;
        private boolean isLeaf = true;

        public OctreeNode(class_238 bounds, int depth) {
            this.bounds = bounds;
            this.depth = depth;
        }

        public void addObject(OctreeObject obj) {
            if (this.isLeaf) {
                this.objects.add(obj);
                if (this.objects.size() > 8 && this.depth < 6 && this.bounds.method_17939() > 16.0 && this.bounds.method_17940() > 16.0 && this.bounds.method_17941() > 16.0) {
                    this.split();
                }
            } else {
                int index = this.getContainingChildIndex(obj.bounds);
                if (index != -1) {
                    this.children[index].addObject(obj);
                } else {
                    this.objects.add(obj);
                }
            }
        }

        public boolean intersects(class_238 box) {
            if (!this.bounds.method_994(box)) {
                return false;
            }
            for (OctreeObject obj : this.objects) {
                if (!obj.bounds.method_994(box)) continue;
                return true;
            }
            if (!this.isLeaf) {
                for (OctreeNode child : this.children) {
                    if (!child.intersects(box)) continue;
                    return true;
                }
            }
            return false;
        }

        public void getIntersectingObjects(class_238 box, Consumer<OctreeObject> consumer) {
            if (!this.bounds.method_994(box)) {
                return;
            }
            for (OctreeObject obj : this.objects) {
                if (!obj.bounds.method_994(box)) continue;
                consumer.accept(obj);
            }
            if (!this.isLeaf) {
                for (OctreeNode child : this.children) {
                    child.getIntersectingObjects(box, consumer);
                }
            }
        }

        private void split() {
            this.children = new OctreeNode[8];
            double halfX = this.bounds.method_17939() / 2.0;
            double halfY = this.bounds.method_17940() / 2.0;
            double halfZ = this.bounds.method_17941() / 2.0;
            double minX = this.bounds.field_1323;
            double minY = this.bounds.field_1322;
            double minZ = this.bounds.field_1321;
            for (int i = 0; i < 8; ++i) {
                double childMinX = minX + (double)(i & 1) * halfX;
                double childMinY = minY + (double)((i & 2) / 2) * halfY;
                double childMinZ = minZ + (double)((i & 4) / 4) * halfZ;
                class_238 childBounds = new class_238(childMinX, childMinY, childMinZ, childMinX + halfX, childMinY + halfY, childMinZ + halfZ);
                this.children[i] = new OctreeNode(childBounds, this.depth + 1);
            }
            ArrayList<OctreeObject> objectsToKeep = new ArrayList<OctreeObject>();
            for (OctreeObject obj : this.objects) {
                int index = this.getContainingChildIndex(obj.bounds);
                if (index != -1) {
                    this.children[index].addObject(obj);
                    continue;
                }
                objectsToKeep.add(obj);
            }
            this.objects.clear();
            this.objects.addAll(objectsToKeep);
            this.isLeaf = false;
        }

        private int getContainingChildIndex(class_238 objBounds) {
            if (this.children == null) {
                return -1;
            }
            for (int i = 0; i < 8; ++i) {
                if (!this.children[i].bounds.method_1008(objBounds.field_1323, objBounds.field_1322, objBounds.field_1321) || !this.children[i].bounds.method_1008(objBounds.field_1320, objBounds.field_1325, objBounds.field_1324)) continue;
                return i;
            }
            return -1;
        }

        public void clear() {
            this.objects.clear();
            if (!this.isLeaf) {
                for (OctreeNode child : this.children) {
                    child.clear();
                }
                this.children = null;
                this.isLeaf = true;
            }
        }
    }

    private static class OctreeObject {
        public final class_238 bounds;
        public final class_265 shape;
        public final Object owner;

        public OctreeObject(class_238 bounds, class_265 shape, Object owner) {
            this.bounds = bounds;
            this.shape = shape;
            this.owner = owner;
        }
    }
}

