/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import me.zcraft.tconfig.config.TritiumConfig;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_0561170;
import net.minecraft.unmapped.C_2942281;
import net.minecraft.unmapped.C_3674802;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_5577922;
import net.minecraft.unmapped.C_8252988;
import net.minecraft.unmapped.C_9590849;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;

public final class EntityTickHelper {
    private static final AtomicReference<Set<C_8252988<?>>> WHITE_LIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<C_8252988<?>>> BLACK_LIST = new AtomicReference(Collections.emptySet());
    private static final List<WildcardPattern> WHITE_PATTERNS = new ArrayList<WildcardPattern>();
    private static final List<WildcardPattern> BLACK_PATTERNS = new ArrayList<WildcardPattern>();
    private static final boolean ignoreDeadEntities = true;
    private static volatile boolean enabled = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    public static boolean shouldSkipTick(C_0539808 entity) {
        if (!enabled) {
            return false;
        }
        if (!entity.m_9283333()) {
            return false;
        }
        if (!entity.m_9283333()) {
            return true;
        }
        C_8252988 type = entity.m_0341989();
        if (EntityTickHelper.matchesWildcard(type, BLACK_PATTERNS) || BLACK_LIST.get().contains(type)) {
            return true;
        }
        if (EntityTickHelper.matchesWildcard(type, WHITE_PATTERNS) || WHITE_LIST.get().contains(type)) {
            return false;
        }
        return !EntityTickHelper.isNearPlayer(entity);
    }

    private static void reloadConfig() {
        enabled = TritiumConfigBase.Entities.EntityOpt.optimizeEntities;
        horizontalRange = TritiumConfigBase.Entities.EntityOpt.horizontalRange;
        verticalRange = TritiumConfigBase.Entities.EntityOpt.verticalRange;
        List<String> whiteRaw = TritiumConfigBase.Entities.EntityOpt.entityWhitelist;
        HashSet whiteIds = Sets.newHashSet();
        WHITE_PATTERNS.clear();
        BLACK_PATTERNS.clear();
        for (String s : whiteRaw) {
            EntityTickHelper.parseEntry(s, whiteIds);
        }
        WHITE_LIST.set((Set<C_8252988<?>>)ImmutableSet.copyOf((Collection)whiteIds));
    }

    private static void parseEntry(String raw, Set<C_8252988<?>> idTarget) {
        if (raw.contains("*") || raw.contains("?")) {
            WHITE_PATTERNS.add(new WildcardPattern(raw));
        } else {
            try {
                C_0561170 key = new C_0561170(raw);
                C_8252988 type = (C_8252988)C_2942281.f_1902270.m_6111517(key);
                if (type != null) {
                    idTarget.add(type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean matchesWildcard(C_8252988<?> type, List<WildcardPattern> list) {
        C_0561170 id = C_2942281.f_1902270.m_7619268(type);
        if (id == null) {
            return false;
        }
        String str = id.toString();
        for (WildcardPattern p : list) {
            if (!p.matches(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearPlayer(C_0539808 entity) {
        C_5553933 level = entity.f_4703454;
        if (!(level instanceof C_3865296)) {
            return true;
        }
        C_3865296 sl = (C_3865296)level;
        C_3674802 pos = entity.m_0490395();
        int cx = pos.m_9150363() >> 4;
        int cz = pos.m_3900258() >> 4;
        int radius = (horizontalRange >> 4) + 1;
        C_5577922 box = new C_5577922((double)(pos.m_9150363() - horizontalRange), (double)(pos.m_4798774() - verticalRange), (double)(pos.m_3900258() - horizontalRange), (double)(pos.m_9150363() + horizontalRange), (double)(pos.m_4798774() + verticalRange), (double)(pos.m_3900258() + horizontalRange));
        for (C_9590849 player : sl.f_5515055) {
            if (!player.m_9283333()) continue;
            C_3674802 ppos = player.m_0490395();
            int pcx = ppos.m_9150363() >> 4;
            int pcz = ppos.m_3900258() >> 4;
            if (Math.abs(pcx - cx) > radius || Math.abs(pcz - cz) > radius || !player.m_8022439().m_8247760(box)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            TritiumConfig config = TritiumConfig.getConfig("tritium");
            config.addReloadListener(EntityTickHelper::reloadConfig);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to register config reload listener", (Throwable)e);
        }
        EntityTickHelper.reloadConfig();
    }

    private static final class WildcardPattern {
        private final Pattern regex;

        WildcardPattern(String raw) {
            String s = raw.replace("?", ".{1}").replace("*", ".*");
            this.regex = Pattern.compile("^" + s + "$");
        }

        boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }
    }
}

