/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.jigsaw;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.octree.BoxOctree;
import org.craftamethyst.tritium.util.OctreeHolder;
import org.craftamethyst.tritium.util.RotationFailMask;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SinglePoolElement.class})
public abstract class SinglePoolElementMixin {
    @Shadow
    @Final
    protected Either<ResourceLocation, StructureTemplate> f_210411_;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void tritium$skipIfGlobalRotationsFailed(StructureTemplateManager manager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, BlockPos offset, BlockPos pos, Rotation rotation, BoundingBox box, RandomSource random, boolean keepJigsaws, CallbackInfoReturnable<Boolean> cir) {
        if (!TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations) {
            return;
        }
        ResourceLocation id = this.f_210411_.left().orElse(null);
        if (id == null) {
            return;
        }
        int templateId = id.hashCode();
        int rotIdx = rotation.ordinal();
        if (RotationFailMask.isFullyFailed(templateId, pos.m_123341_(), pos.m_123342_(), pos.m_123343_())) {
            cir.setReturnValue((Object)false);
            return;
        }
        BoxOctree octree = OctreeHolder.get();
        if (octree == null) {
            return;
        }
        StructureTemplate tpl = manager.m_230359_(id);
        BoundingBox bb = tpl.m_74633_(new StructurePlaceSettings().m_74379_(rotation), pos);
        AABB aabb = new AABB((double)bb.m_162395_(), (double)bb.m_162396_(), (double)bb.m_162398_(), (double)bb.m_162399_(), (double)bb.m_162400_(), (double)bb.m_162401_());
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection && octree.intersects(aabb)) {
            if (RotationFailMask.markFailed(templateId, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), rotIdx)) {
                // empty if block
            }
            cir.setReturnValue((Object)false);
            return;
        }
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection) {
            VoxelShape shape = Shapes.m_83064_((AABB)aabb);
            if (!shape.m_83281_()) {
                octree.addShape(shape, this);
            }
            octree.addShape(shape, this);
        }
    }
}

