/*
 * Decompiled with CFR 0.152.
 */
package me.zcraft.tconfig.config;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import me.zcraft.tconfig.annotation.Range;
import me.zcraft.tconfig.annotation.SubCategory;
import me.zcraft.tconfig.config.TritiumConfig;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.craftamethyst.tritium.TritiumCommon;

public class TritiumAutoConfig {
    private final TritiumConfig config;
    private final Map<String, FieldAccessor> fieldAccessors = new ConcurrentHashMap<String, FieldAccessor>();

    public TritiumAutoConfig(TritiumConfig config) {
        this.config = config;
    }

    private static Field findField(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                return TritiumAutoConfig.findField(superClass, fieldName);
            }
            return null;
        }
    }

    private static boolean hasConfigurableFields(Object section) {
        if (section == null) {
            return false;
        }
        try {
            for (Field field : section.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.isSynthetic()) continue;
                if (!field.isAnnotationPresent(SubCategory.class)) {
                    return true;
                }
                Object subSection = field.get(section);
                if (!TritiumAutoConfig.hasConfigurableFields(subSection)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public Screen createConfigScreen(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)("config." + this.config.getModId() + ".title"))).transparentBackground().setSavingRunnable(this.config::save);
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        boolean createdAnyCategory = false;
        try {
            Object configObj = this.config.get();
            Class<?> configClass = configObj.getClass();
            this.initializeFieldAccessors(configObj);
            for (Field sectionField : configClass.getDeclaredFields()) {
                sectionField.setAccessible(true);
                Object section = sectionField.get(configObj);
                String sectionName = sectionField.getName();
                if (section == null || !TritiumAutoConfig.hasConfigurableFields(section)) continue;
                ConfigCategory category = builder.getOrCreateCategory((Component)Component.translatable((String)("config." + this.config.getModId() + ".category." + sectionName)));
                createdAnyCategory = true;
                this.generateSectionEntries(entryBuilder, category, section, sectionName);
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to generate config screen for mod: {}", (Object)this.config.getModId(), (Object)e);
        }
        if (!createdAnyCategory) {
            builder.getOrCreateCategory((Component)Component.translatable((String)("config." + this.config.getModId() + ".category.general")));
        }
        return builder.build();
    }

    private void initializeFieldAccessors(Object config) throws Exception {
        if (!this.fieldAccessors.isEmpty()) {
            return;
        }
        for (Field sectionField : config.getClass().getDeclaredFields()) {
            sectionField.setAccessible(true);
            Object section = sectionField.get(config);
            this.cacheFieldAccessorsRecursive(section, sectionField.getName());
        }
    }

    private void cacheFieldAccessorsRecursive(Object section, String path) throws Exception {
        if (section == null) {
            return;
        }
        for (Field field : section.getClass().getDeclaredFields()) {
            String fullPath;
            field.setAccessible(true);
            String string = fullPath = path.isEmpty() ? field.getName() : path + "." + field.getName();
            if (field.isAnnotationPresent(SubCategory.class)) {
                Object subSection = field.get(section);
                this.cacheFieldAccessorsRecursive(subSection, fullPath);
                continue;
            }
            this.fieldAccessors.put(fullPath, new ReflectionFieldAccessor(field));
        }
    }

    private void generateSectionEntries(ConfigEntryBuilder entryBuilder, ConfigCategory category, Object section, String sectionName) {
        if (section == null) {
            return;
        }
        try {
            for (Field field : section.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object currentValue = field.get(section);
                String translationKey = "config." + this.config.getModId() + "." + sectionName + "." + fieldName.replace('.', '_');
                if (field.isAnnotationPresent(SubCategory.class)) {
                    SubCategory subCat = field.getAnnotation(SubCategory.class);
                    SubCategoryBuilder subCategoryBuilder = entryBuilder.startSubCategory((Component)Component.translatable((String)translationKey));
                    this.generateSubCategoryEntries(entryBuilder, subCategoryBuilder, currentValue, sectionName, fieldName);
                    category.addEntry((AbstractConfigListEntry)subCategoryBuilder.build());
                    continue;
                }
                String fullPath = sectionName + "." + fieldName;
                FieldAccessor accessor = this.fieldAccessors.get(fullPath);
                if (accessor == null) continue;
                this.generateFieldEntry(entryBuilder, category, accessor, currentValue, translationKey, fullPath);
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to generate entries for section: {}", (Object)sectionName, (Object)e);
        }
    }

    private void generateSubCategoryEntries(ConfigEntryBuilder entryBuilder, SubCategoryBuilder subCategoryBuilder, Object section, String sectionName, String path) {
        if (section == null) {
            return;
        }
        try {
            for (Field field : section.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object currentValue = field.get(section);
                String fullPath = path.isEmpty() ? fieldName : path + "." + fieldName;
                String accessorPath = sectionName + "." + fullPath;
                String translationKey = "config." + this.config.getModId() + "." + sectionName + "." + fullPath.replace('.', '_');
                if (field.isAnnotationPresent(SubCategory.class)) {
                    SubCategory subCat = field.getAnnotation(SubCategory.class);
                    SubCategoryBuilder nestedSubCategoryBuilder = entryBuilder.startSubCategory((Component)Component.translatable((String)translationKey));
                    this.generateSubCategoryEntries(entryBuilder, nestedSubCategoryBuilder, currentValue, sectionName, fullPath);
                    subCategoryBuilder.add((AbstractConfigListEntry)nestedSubCategoryBuilder.build());
                    continue;
                }
                FieldAccessor accessor = this.fieldAccessors.get(accessorPath);
                if (accessor != null) {
                    this.generateSubCategoryFieldEntry(entryBuilder, subCategoryBuilder, accessor, currentValue, translationKey, accessorPath);
                    continue;
                }
                TritiumCommon.LOG.warn("No accessor found for path: {}", (Object)accessorPath);
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to generate subcategory entries for section: {}", (Object)sectionName, (Object)e);
        }
    }

    private void generateFieldEntry(ConfigEntryBuilder entryBuilder, ConfigCategory category, FieldAccessor accessor, Object currentValue, String translationKey, String fullPath) {
        Class<?> fieldType = accessor.getType();
        try {
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                category.addEntry((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.translatable((String)translationKey), ((Boolean)currentValue).booleanValue()).setDefaultValue((Object)((Boolean)accessor.getDefaultValue()))).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(fullPath)).build());
            } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                IntFieldBuilder intField = ((IntFieldBuilder)entryBuilder.startIntField((Component)Component.translatable((String)translationKey), ((Integer)currentValue).intValue()).setDefaultValue((Object)((Integer)accessor.getDefaultValue()))).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(fullPath));
                Range range = accessor.getRangeAnnotation();
                if (range != null) {
                    intField.setMin((int)range.min()).setMax((int)range.max());
                }
                category.addEntry((AbstractConfigListEntry)intField.build());
            } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                DoubleFieldBuilder doubleField = ((DoubleFieldBuilder)entryBuilder.startDoubleField((Component)Component.translatable((String)translationKey), ((Double)currentValue).doubleValue()).setDefaultValue((Object)((Double)accessor.getDefaultValue()))).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(fullPath));
                Range range = accessor.getRangeAnnotation();
                if (range != null) {
                    doubleField.setMin(range.min()).setMax(range.max());
                }
                category.addEntry((AbstractConfigListEntry)doubleField.build());
            } else if (fieldType == String.class) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.translatable((String)translationKey), (String)currentValue).setDefaultValue((String)accessor.getDefaultValue()).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(fullPath)).build());
            } else if (List.class.isAssignableFrom(fieldType)) {
                List currentList = (List)currentValue;
                category.addEntry((AbstractConfigListEntry)entryBuilder.startStrList((Component)Component.translatable((String)translationKey), currentList).setDefaultValue((List)accessor.getDefaultValue()).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(fullPath)).build());
            } else if (fieldType.isEnum()) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.translatable((String)translationKey), fieldType, (Enum)currentValue).setDefaultValue((Enum)accessor.getDefaultValue()).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(fullPath)).build());
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to generate field entry: {}", (Object)fullPath, (Object)e);
        }
    }

    private void generateSubCategoryFieldEntry(ConfigEntryBuilder entryBuilder, SubCategoryBuilder subCategoryBuilder, FieldAccessor accessor, Object currentValue, String translationKey, String accessorPath) {
        Class<?> fieldType = accessor.getType();
        try {
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                subCategoryBuilder.add((AbstractConfigListEntry)((BooleanToggleBuilder)entryBuilder.startBooleanToggle((Component)Component.translatable((String)translationKey), ((Boolean)currentValue).booleanValue()).setDefaultValue((Object)((Boolean)accessor.getDefaultValue()))).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(accessorPath)).build());
            } else if (fieldType == Integer.TYPE || fieldType == Integer.class) {
                IntFieldBuilder intField = ((IntFieldBuilder)entryBuilder.startIntField((Component)Component.translatable((String)translationKey), ((Integer)currentValue).intValue()).setDefaultValue((Object)((Integer)accessor.getDefaultValue()))).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(accessorPath));
                Range range = accessor.getRangeAnnotation();
                if (range != null) {
                    intField.setMin((int)range.min()).setMax((int)range.max());
                }
                subCategoryBuilder.add((AbstractConfigListEntry)intField.build());
            } else if (fieldType == Double.TYPE || fieldType == Double.class) {
                DoubleFieldBuilder doubleField = ((DoubleFieldBuilder)entryBuilder.startDoubleField((Component)Component.translatable((String)translationKey), ((Double)currentValue).doubleValue()).setDefaultValue((Object)((Double)accessor.getDefaultValue()))).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(accessorPath));
                Range range = accessor.getRangeAnnotation();
                if (range != null) {
                    doubleField.setMin(range.min()).setMax(range.max());
                }
                subCategoryBuilder.add((AbstractConfigListEntry)doubleField.build());
            } else if (fieldType == String.class) {
                subCategoryBuilder.add((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.translatable((String)translationKey), (String)currentValue).setDefaultValue((String)accessor.getDefaultValue()).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(accessorPath)).build());
            } else if (List.class.isAssignableFrom(fieldType)) {
                List currentList = (List)currentValue;
                subCategoryBuilder.add((AbstractConfigListEntry)entryBuilder.startStrList((Component)Component.translatable((String)translationKey), currentList).setDefaultValue((List)accessor.getDefaultValue()).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(accessorPath)).build());
            } else if (fieldType.isEnum()) {
                subCategoryBuilder.add((AbstractConfigListEntry)entryBuilder.startEnumSelector((Component)Component.translatable((String)translationKey), fieldType, (Enum)currentValue).setDefaultValue((Enum)accessor.getDefaultValue()).setTooltip(new Component[]{Component.translatable((String)(translationKey + ".tooltip"))}).setSaveConsumer(this.createSaveConsumer(accessorPath)).build());
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to generate subcategory field entry: {}", (Object)accessorPath, (Object)e);
        }
    }

    private <T> Consumer<T> createSaveConsumer(String fullPath) {
        return value -> this.updateConfigValue(fullPath, value);
    }

    private void updateConfigValue(String fullPath, Object value) {
        try {
            TritiumCommon.LOG.debug("Updating config value: {} = {}", (Object)fullPath, value);
            String[] pathParts = fullPath.split("\\.");
            if (pathParts.length < 2) {
                TritiumCommon.LOG.warn("Invalid path format: {}", (Object)fullPath);
                return;
            }
            FieldAccessor accessor = this.fieldAccessors.get(fullPath);
            if (accessor == null) {
                TritiumCommon.LOG.warn("No field accessor found for path: {}", (Object)fullPath);
                TritiumCommon.LOG.debug("Available accessors: {}", this.fieldAccessors.keySet());
                return;
            }
            Object currentObj = this.config.get();
            for (int i = 0; i < pathParts.length - 1; ++i) {
                String part = pathParts[i];
                Field field = TritiumAutoConfig.findField(currentObj.getClass(), part);
                if (field == null) {
                    TritiumCommon.LOG.warn("Field not found: {} in path: {}", (Object)part, (Object)fullPath);
                    return;
                }
                field.setAccessible(true);
                Object nextObj = field.get(currentObj);
                if (nextObj == null) {
                    try {
                        nextObj = field.getType().newInstance();
                        field.set(currentObj, nextObj);
                        TritiumCommon.LOG.debug("Created new instance for: {}", (Object)part);
                    }
                    catch (Exception e) {
                        TritiumCommon.LOG.error("Failed to create instance for: {}", (Object)part, (Object)e);
                        return;
                    }
                }
                currentObj = nextObj;
            }
            accessor.setValue(currentObj, value);
            this.config.save();
            TritiumCommon.LOG.debug("Successfully updated config value: {}", (Object)fullPath);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to update config value: {}", (Object)fullPath, (Object)e);
        }
    }

    private static class ReflectionFieldAccessor
    implements FieldAccessor {
        private final Field field;
        private final Range range;

        public ReflectionFieldAccessor(Field field) {
            this.field = field;
            this.field.setAccessible(true);
            this.range = field.getAnnotation(Range.class);
        }

        @Override
        public Object getValue(Object obj) throws Exception {
            return this.field.get(obj);
        }

        @Override
        public void setValue(Object obj, Object value) throws Exception {
            this.field.set(obj, value);
        }

        @Override
        public Object getDefaultValue() throws Exception {
            Object defaultInstance = this.field.getDeclaringClass().newInstance();
            return this.field.get(defaultInstance);
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Range getRangeAnnotation() {
            return this.range;
        }
    }

    private static interface FieldAccessor {
        public Object getValue(Object var1) throws Exception;

        public void setValue(Object var1, Object var2) throws Exception;

        public Object getDefaultValue() throws Exception;

        public Class<?> getType();

        public Range getRangeAnnotation();
    }
}

