/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.cull.AABBCullingManager;
import org.craftamethyst.tritium.cull.CullCache;

public class TritiumClient {
    public static TritiumClient instance;
    private final CullCache cache = new CullCache();
    private final AABBCullingManager aabbCulling = new AABBCullingManager();
    private Vec3 lastCameraPos = Vec3.ZERO;
    private int framesSinceLastUpdate = 0;

    public TritiumClient() {
        instance = this;
    }

    public static void shutdown() {
        if (instance != null) {
            TritiumClient.instance.aabbCulling.dispose();
            TritiumClient.instance.cache.clear();
        }
    }

    public boolean shouldSkipEntity(Entity e) {
        if (e == null) {
            return false;
        }
        if (!TritiumConfigBase.Rendering.EntityCulling.enableCulling) {
            return false;
        }
        if (this.isEntityBlacklisted(e)) {
            return false;
        }
        this.updateCameraPosition();
        return this.aabbCulling.shouldCullEntity(e);
    }

    public boolean shouldSkipBlockEntity(BlockEntity be) {
        if (be == null) {
            return false;
        }
        if (!TritiumConfigBase.Rendering.EntityCulling.enableBlockEntityCulling) {
            return false;
        }
        this.updateCameraPosition();
        return this.aabbCulling.shouldCullBlockEntity(be);
    }

    public CullCache getCullCache() {
        return this.cache;
    }

    public AABBCullingManager getAABBCullingManager() {
        return this.aabbCulling;
    }

    private boolean isEntityBlacklisted(Entity entity) {
        ResourceLocation entityId = EntityType.getKey((EntityType)entity.getType());
        String entityName = entityId.toString();
        List<String> blacklist = TritiumConfigBase.Rendering.EntityCulling.entityBlacklist;
        for (String pattern : blacklist) {
            if (!this.matchesPattern(entityName, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(String entityName, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.endsWith(":*")) {
            String namespace = pattern.substring(0, pattern.length() - 2);
            return entityName.startsWith(namespace + ":");
        }
        return entityName.equals(pattern);
    }

    private void updateCameraPosition() {
        Minecraft mc = Minecraft.getInstance();
        Vec3 currentCameraPos = mc.gameRenderer.getMainCamera().getPosition();
        ++this.framesSinceLastUpdate;
        if (this.framesSinceLastUpdate >= 5 || currentCameraPos.distanceToSqr(this.lastCameraPos) > 4.0) {
            this.lastCameraPos = currentCameraPos;
            this.aabbCulling.updateCameraPosition();
            this.framesSinceLastUpdate = 0;
        }
    }
}

