/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CullCache {
    private static final long ENTITY_CACHE_TIMEOUT = 200L;
    private static final long BLOCK_ENTITY_CACHE_TIMEOUT = 500L;
    private final Int2BooleanOpenHashMap entityCullCache = new Int2BooleanOpenHashMap(8192);
    private final Long2BooleanOpenHashMap blockEntityCullCache = new Long2BooleanOpenHashMap(8192);
    private final Long2LongOpenHashMap entityCacheTimestamps = new Long2LongOpenHashMap(8192);
    private final Long2LongOpenHashMap blockEntityCacheTimestamps = new Long2LongOpenHashMap(8192);
    private final CullResult cachedTrueResult = new CullResult(true, true);
    private final CullResult cachedFalseResult = new CullResult(true, false);
    private final CullResult uncachedResult = new CullResult(false, false);
    private int entityCacheHits = 0;
    private int entityCacheMisses = 0;
    private int blockEntityCacheHits = 0;
    private int blockEntityCacheMisses = 0;

    public CullResult checkEntity(Entity entity) {
        if (entity == null) {
            return this.uncachedResult;
        }
        int entityId = entity.getId();
        long cacheKey = this.entityHash(entityId);
        if (this.isEntityCached(cacheKey)) {
            ++this.entityCacheHits;
            boolean culled = this.entityCullCache.get(entityId);
            return culled ? this.cachedTrueResult : this.cachedFalseResult;
        }
        ++this.entityCacheMisses;
        return this.uncachedResult;
    }

    public void cacheEntity(Entity entity, boolean culled) {
        if (entity == null) {
            return;
        }
        int entityId = entity.getId();
        long cacheKey = this.entityHash(entityId);
        this.cacheEntityInternal(cacheKey, entityId, culled);
    }

    public CullResult checkBlockEntity(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return this.uncachedResult;
        }
        long blockPos = blockEntity.getBlockPos().asLong();
        long cacheKey = this.blockEntityHash(blockPos);
        if (this.isBlockEntityCached(cacheKey)) {
            ++this.blockEntityCacheHits;
            boolean culled = this.blockEntityCullCache.get(blockPos);
            return culled ? this.cachedTrueResult : this.cachedFalseResult;
        }
        ++this.blockEntityCacheMisses;
        return this.uncachedResult;
    }

    public void cacheBlockEntity(BlockEntity blockEntity, boolean culled) {
        if (blockEntity == null) {
            return;
        }
        long blockPos = blockEntity.getBlockPos().asLong();
        long cacheKey = this.blockEntityHash(blockPos);
        this.cacheBlockEntityInternal(cacheKey, blockPos, culled);
    }

    public void clear() {
        this.entityCullCache.clear();
        this.blockEntityCullCache.clear();
        this.entityCacheTimestamps.clear();
        this.blockEntityCacheTimestamps.clear();
        this.entityCacheHits = 0;
        this.entityCacheMisses = 0;
        this.blockEntityCacheHits = 0;
        this.blockEntityCacheMisses = 0;
    }

    public double getEntityCacheHitRate() {
        int total = this.entityCacheHits + this.entityCacheMisses;
        return total == 0 ? 0.0 : (double)this.entityCacheHits / (double)total;
    }

    public double getBlockEntityCacheHitRate() {
        int total = this.blockEntityCacheHits + this.blockEntityCacheMisses;
        return total == 0 ? 0.0 : (double)this.blockEntityCacheHits / (double)total;
    }

    private boolean isEntityCached(long cacheKey) {
        if (!this.entityCacheTimestamps.containsKey(cacheKey)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - this.entityCacheTimestamps.get(cacheKey) < 200L;
    }

    private void cacheEntityInternal(long cacheKey, int entityId, boolean culled) {
        long currentTime = System.currentTimeMillis();
        this.entityCullCache.put(entityId, culled);
        this.entityCacheTimestamps.put(cacheKey, currentTime);
    }

    private boolean isBlockEntityCached(long cacheKey) {
        if (!this.blockEntityCacheTimestamps.containsKey(cacheKey)) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - this.blockEntityCacheTimestamps.get(cacheKey) < 500L;
    }

    private void cacheBlockEntityInternal(long cacheKey, long blockPos, boolean culled) {
        long currentTime = System.currentTimeMillis();
        this.blockEntityCullCache.put(blockPos, culled);
        this.blockEntityCacheTimestamps.put(cacheKey, currentTime);
    }

    private long entityHash(int entityId) {
        return (long)entityId * 2654434745L;
    }

    private long blockEntityHash(long blockPos) {
        return blockPos * 2654434745L;
    }

    public static class CullResult {
        private final boolean cached;
        private final boolean culled;

        public CullResult(boolean cached, boolean culled) {
            this.cached = cached;
            this.culled = culled;
        }

        public boolean isCached() {
            return this.cached;
        }

        public boolean isCulled() {
            return this.culled;
        }
    }
}

