/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.cache;

import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Block.BlockStatePairKey.class})
public class BlockStatePairKeyLazyCache {
    @Final
    @Shadow
    private BlockState first;
    @Final
    @Shadow
    private BlockState second;
    @Final
    @Shadow
    private Direction direction;
    @Unique
    private int tritium$cachedHash = 0;
    @Unique
    private boolean tritium$isHashComputed = false;

    @Inject(method={"hashCode"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHashCode(CallbackInfoReturnable<Integer> cir) {
        if (!TritiumConfigBase.Performance.BlockStateCache.blockStatePairKeyCache) {
            return;
        }
        if (!this.tritium$isHashComputed) {
            this.tritium$computeAndCacheHashCode();
        }
        cir.setReturnValue((Object)this.tritium$cachedHash);
    }

    @Unique
    private void tritium$computeAndCacheHashCode() {
        int firstHash = this.first.hashCode();
        int secondHash = this.second.hashCode();
        int directionHash = this.direction.hashCode();
        int result = firstHash;
        result = (result << 5) - result + secondHash;
        this.tritium$cachedHash = result = (result << 5) - result + directionHash;
        this.tritium$isHashComputed = true;
    }
}

