/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.chunk;

import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ImprovedNoise.class})
public abstract class ImprovedNoiseMixin {
    @Shadow
    @Final
    public double xo;
    @Shadow
    @Final
    public double yo;
    @Shadow
    @Final
    public double zo;
    @Shadow
    @Final
    private byte[] p;
    @Unique
    private static final double[] OPTIMIZED_GRADIENTS = ImprovedNoiseMixin.tritium$createOptimizedGradients();
    @Unique
    private int[] tritium$optimizedPermutation;

    @Unique
    private static double[] tritium$createOptimizedGradients() {
        int[][] simplexGradients = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {-1, 1, 0}, {0, -1, 1}, {0, -1, -1}};
        double[] gradients = new double[48];
        for (int i = 0; i < 16; ++i) {
            int base = i * 3;
            gradients[base] = simplexGradients[i][0];
            gradients[base + 1] = simplexGradients[i][1];
            gradients[base + 2] = simplexGradients[i][2];
        }
        return gradients;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void tritium$onInit(RandomSource random, CallbackInfo ci) {
        this.tritium$optimizedPermutation = new int[512];
        for (int i = 0; i < 256; ++i) {
            int value;
            this.tritium$optimizedPermutation[i] = value = this.p[i] & 0xFF;
            this.tritium$optimizedPermutation[i + 256] = value;
        }
    }

    @Unique
    private int tritium$getPerm(int index) {
        return this.tritium$optimizedPermutation[index & 0xFF];
    }

    @Deprecated
    @Overwrite
    public double noise(double x, double y, double z, double yScale, double yMax) {
        double yShift;
        double offsetX = x + this.xo;
        double offsetY = y + this.yo;
        double offsetZ = z + this.zo;
        int gridX = Mth.floor((double)offsetX);
        int gridY = Mth.floor((double)offsetY);
        int gridZ = Mth.floor((double)offsetZ);
        double deltaX = offsetX - (double)gridX;
        double deltaY = offsetY - (double)gridY;
        double deltaZ = offsetZ - (double)gridZ;
        if (yScale != 0.0) {
            double clampedY = yMax >= 0.0 && yMax < deltaY ? yMax : deltaY;
            yShift = (double)Mth.floor((double)(clampedY / yScale + (double)1.0E-7f)) * yScale;
        } else {
            yShift = 0.0;
        }
        return this.tritium$optimizedSampleAndLerp(gridX, gridY, gridZ, deltaX, deltaY - yShift, deltaZ, deltaY);
    }

    @Unique
    private double tritium$optimizedSampleAndLerp(int gridX, int gridY, int gridZ, double deltaX, double weirdDeltaY, double deltaZ, double deltaY) {
        int idxX0 = this.tritium$getPerm(gridX);
        int idxX1 = this.tritium$getPerm(gridX + 1);
        int idxXY00 = this.tritium$getPerm(idxX0 + gridY);
        int idxXY10 = this.tritium$getPerm(idxX1 + gridY);
        int idxXY01 = this.tritium$getPerm(idxX0 + gridY + 1);
        int idxXY11 = this.tritium$getPerm(idxX1 + gridY + 1);
        int gradIdx000 = this.tritium$getPerm(idxXY00 + gridZ) & 0xF;
        int gradIdx100 = this.tritium$getPerm(idxXY10 + gridZ) & 0xF;
        int gradIdx010 = this.tritium$getPerm(idxXY01 + gridZ) & 0xF;
        int gradIdx110 = this.tritium$getPerm(idxXY11 + gridZ) & 0xF;
        int gradIdx001 = this.tritium$getPerm(idxXY00 + gridZ + 1) & 0xF;
        int gradIdx101 = this.tritium$getPerm(idxXY10 + gridZ + 1) & 0xF;
        int gradIdx011 = this.tritium$getPerm(idxXY01 + gridZ + 1) & 0xF;
        int gradIdx111 = this.tritium$getPerm(idxXY11 + gridZ + 1) & 0xF;
        double d0 = this.tritium$optimizedGradDot(gradIdx000, deltaX, weirdDeltaY, deltaZ);
        double d1 = this.tritium$optimizedGradDot(gradIdx100, deltaX - 1.0, weirdDeltaY, deltaZ);
        double d2 = this.tritium$optimizedGradDot(gradIdx010, deltaX, weirdDeltaY - 1.0, deltaZ);
        double d3 = this.tritium$optimizedGradDot(gradIdx110, deltaX - 1.0, weirdDeltaY - 1.0, deltaZ);
        double d4 = this.tritium$optimizedGradDot(gradIdx001, deltaX, weirdDeltaY, deltaZ - 1.0);
        double d5 = this.tritium$optimizedGradDot(gradIdx101, deltaX - 1.0, weirdDeltaY, deltaZ - 1.0);
        double d6 = this.tritium$optimizedGradDot(gradIdx011, deltaX, weirdDeltaY - 1.0, deltaZ - 1.0);
        double d7 = this.tritium$optimizedGradDot(gradIdx111, deltaX - 1.0, weirdDeltaY - 1.0, deltaZ - 1.0);
        double smoothX = this.tritium$optimizedSmoothstep(deltaX);
        double smoothY = this.tritium$optimizedSmoothstep(deltaY);
        double smoothZ = this.tritium$optimizedSmoothstep(deltaZ);
        return Mth.lerp3((double)smoothX, (double)smoothY, (double)smoothZ, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7);
    }

    @Unique
    private double tritium$optimizedGradDot(int gradIdx, double x, double y, double z) {
        int baseIdx = gradIdx * 3;
        double gradX = OPTIMIZED_GRADIENTS[baseIdx];
        double gradY = OPTIMIZED_GRADIENTS[baseIdx + 1];
        double gradZ = OPTIMIZED_GRADIENTS[baseIdx + 2];
        return gradX * x + gradY * y + gradZ * z;
    }

    @Unique
    private double tritium$optimizedSmoothstep(double t) {
        double t3 = t * t * t;
        return t3 * (t * (t * 6.0 - 15.0) + 10.0);
    }

    @Overwrite
    public double noiseWithDerivative(double x, double y, double z, double[] values) {
        double offsetX = x + this.xo;
        double offsetY = y + this.yo;
        double offsetZ = z + this.zo;
        int gridX = Mth.floor((double)offsetX);
        int gridY = Mth.floor((double)offsetY);
        int gridZ = Mth.floor((double)offsetZ);
        double deltaX = offsetX - (double)gridX;
        double deltaY = offsetY - (double)gridY;
        double deltaZ = offsetZ - (double)gridZ;
        return this.tritium$optimizedSampleWithDerivative(gridX, gridY, gridZ, deltaX, deltaY, deltaZ, values);
    }

    @Unique
    private double tritium$optimizedSampleWithDerivative(int gridX, int gridY, int gridZ, double deltaX, double deltaY, double deltaZ, double[] values) {
        int idxX0 = this.tritium$getPerm(gridX);
        int idxX1 = this.tritium$getPerm(gridX + 1);
        int idxXY00 = this.tritium$getPerm(idxX0 + gridY);
        int idxXY10 = this.tritium$getPerm(idxX1 + gridY);
        int idxXY01 = this.tritium$getPerm(idxX0 + gridY + 1);
        int idxXY11 = this.tritium$getPerm(idxX1 + gridY + 1);
        int gradIdx000 = this.tritium$getPerm(idxXY00 + gridZ) & 0xF;
        int gradIdx100 = this.tritium$getPerm(idxXY10 + gridZ) & 0xF;
        int gradIdx010 = this.tritium$getPerm(idxXY01 + gridZ) & 0xF;
        int gradIdx110 = this.tritium$getPerm(idxXY11 + gridZ) & 0xF;
        int gradIdx001 = this.tritium$getPerm(idxXY00 + gridZ + 1) & 0xF;
        int gradIdx101 = this.tritium$getPerm(idxXY10 + gridZ + 1) & 0xF;
        int gradIdx011 = this.tritium$getPerm(idxXY01 + gridZ + 1) & 0xF;
        int gradIdx111 = this.tritium$getPerm(idxXY11 + gridZ + 1) & 0xF;
        int base000 = gradIdx000 * 3;
        int base100 = gradIdx100 * 3;
        int base010 = gradIdx010 * 3;
        int base110 = gradIdx110 * 3;
        int base001 = gradIdx001 * 3;
        int base101 = gradIdx101 * 3;
        int base011 = gradIdx011 * 3;
        int base111 = gradIdx111 * 3;
        double d0 = this.tritium$optimizedGradDot(gradIdx000, deltaX, deltaY, deltaZ);
        double d1 = this.tritium$optimizedGradDot(gradIdx100, deltaX - 1.0, deltaY, deltaZ);
        double d2 = this.tritium$optimizedGradDot(gradIdx010, deltaX, deltaY - 1.0, deltaZ);
        double d3 = this.tritium$optimizedGradDot(gradIdx110, deltaX - 1.0, deltaY - 1.0, deltaZ);
        double d4 = this.tritium$optimizedGradDot(gradIdx001, deltaX, deltaY, deltaZ - 1.0);
        double d5 = this.tritium$optimizedGradDot(gradIdx101, deltaX - 1.0, deltaY, deltaZ - 1.0);
        double d6 = this.tritium$optimizedGradDot(gradIdx011, deltaX, deltaY - 1.0, deltaZ - 1.0);
        double d7 = this.tritium$optimizedGradDot(gradIdx111, deltaX - 1.0, deltaY - 1.0, deltaZ - 1.0);
        double smoothX = this.tritium$optimizedSmoothstep(deltaX);
        double smoothY = this.tritium$optimizedSmoothstep(deltaY);
        double smoothZ = this.tritium$optimizedSmoothstep(deltaZ);
        double gradX0 = OPTIMIZED_GRADIENTS[base000];
        double gradX1 = OPTIMIZED_GRADIENTS[base100];
        double gradX2 = OPTIMIZED_GRADIENTS[base010];
        double gradX3 = OPTIMIZED_GRADIENTS[base110];
        double gradX4 = OPTIMIZED_GRADIENTS[base001];
        double gradX5 = OPTIMIZED_GRADIENTS[base101];
        double gradX6 = OPTIMIZED_GRADIENTS[base011];
        double gradX7 = OPTIMIZED_GRADIENTS[base111];
        double gradY0 = OPTIMIZED_GRADIENTS[base000 + 1];
        double gradY1 = OPTIMIZED_GRADIENTS[base100 + 1];
        double gradY2 = OPTIMIZED_GRADIENTS[base010 + 1];
        double gradY3 = OPTIMIZED_GRADIENTS[base110 + 1];
        double gradY4 = OPTIMIZED_GRADIENTS[base001 + 1];
        double gradY5 = OPTIMIZED_GRADIENTS[base101 + 1];
        double gradY6 = OPTIMIZED_GRADIENTS[base011 + 1];
        double gradY7 = OPTIMIZED_GRADIENTS[base111 + 1];
        double gradZ0 = OPTIMIZED_GRADIENTS[base000 + 2];
        double gradZ1 = OPTIMIZED_GRADIENTS[base100 + 2];
        double gradZ2 = OPTIMIZED_GRADIENTS[base010 + 2];
        double gradZ3 = OPTIMIZED_GRADIENTS[base110 + 2];
        double gradZ4 = OPTIMIZED_GRADIENTS[base001 + 2];
        double gradZ5 = OPTIMIZED_GRADIENTS[base101 + 2];
        double gradZ6 = OPTIMIZED_GRADIENTS[base011 + 2];
        double gradZ7 = OPTIMIZED_GRADIENTS[base111 + 2];
        double interpolatedX = Mth.lerp3((double)smoothX, (double)smoothY, (double)smoothZ, (double)gradX0, (double)gradX1, (double)gradX2, (double)gradX3, (double)gradX4, (double)gradX5, (double)gradX6, (double)gradX7);
        double interpolatedY = Mth.lerp3((double)smoothX, (double)smoothY, (double)smoothZ, (double)gradY0, (double)gradY1, (double)gradY2, (double)gradY3, (double)gradY4, (double)gradY5, (double)gradY6, (double)gradY7);
        double interpolatedZ = Mth.lerp3((double)smoothX, (double)smoothY, (double)smoothZ, (double)gradZ0, (double)gradZ1, (double)gradZ2, (double)gradZ3, (double)gradZ4, (double)gradZ5, (double)gradZ6, (double)gradZ7);
        double diff01 = d1 - d0;
        double diff23 = d3 - d2;
        double diff45 = d5 - d4;
        double diff67 = d7 - d6;
        double diff02 = d2 - d0;
        double diff46 = d6 - d4;
        double diff13 = d3 - d1;
        double diff57 = d7 - d5;
        double diff04 = d4 - d0;
        double diff15 = d5 - d1;
        double diff26 = d6 - d2;
        double diff37 = d7 - d3;
        double derivativeX = Mth.lerp2((double)smoothY, (double)smoothZ, (double)diff01, (double)diff23, (double)diff45, (double)diff67);
        double derivativeY = Mth.lerp2((double)smoothZ, (double)smoothX, (double)diff02, (double)diff46, (double)diff13, (double)diff57);
        double derivativeZ = Mth.lerp2((double)smoothX, (double)smoothY, (double)diff04, (double)diff15, (double)diff26, (double)diff37);
        double smoothDerivativeX = this.tritium$optimizedSmoothstepDerivative(deltaX);
        double smoothDerivativeY = this.tritium$optimizedSmoothstepDerivative(deltaY);
        double smoothDerivativeZ = this.tritium$optimizedSmoothstepDerivative(deltaZ);
        values[0] = values[0] + (interpolatedX + smoothDerivativeX * derivativeX);
        values[1] = values[1] + (interpolatedY + smoothDerivativeY * derivativeY);
        values[2] = values[2] + (interpolatedZ + smoothDerivativeZ * derivativeZ);
        return Mth.lerp3((double)smoothX, (double)smoothY, (double)smoothZ, (double)d0, (double)d1, (double)d2, (double)d3, (double)d4, (double)d5, (double)d6, (double)d7);
    }

    @Unique
    private double tritium$optimizedSmoothstepDerivative(double t) {
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        return 30.0 * t4 - 60.0 * t3 + 30.0 * t2;
    }
}

