/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.chunk;

import net.minecraft.core.QuartPos;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NoiseChunk.class})
public class NoiseSamplingCacheMixin {
    @Unique
    private final ThreadLocal<DensityFunction.SinglePointContext> tritium$reusableContext = ThreadLocal.withInitial(() -> new DensityFunction.SinglePointContext(0, 0, 0));
    @Final
    @Shadow
    int firstNoiseX;
    @Final
    @Shadow
    int firstNoiseZ;

    @Inject(method={"initializeForFirstCellX"}, at={@At(value="HEAD")})
    private void onFirstCell(CallbackInfo ci) {
        if (!TritiumConfigBase.ServerPerformance.NoiseSamplingCache.noiseSamplingCache) {
            return;
        }
        int startBlockX = QuartPos.toBlock((int)this.firstNoiseX);
        int startBlockZ = QuartPos.toBlock((int)this.firstNoiseZ);
        this.tritium$reusableContext.set(new DensityFunction.SinglePointContext(startBlockX, 0, startBlockZ));
    }
}

