/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.vertex;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import org.craftamethyst.tritium.mixin.client.renderer.vertex.PoseStackPoseAccessor;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={VertexConsumer.class})
public interface VertexConsumerMixin {
    @Overwrite
    default public VertexConsumer addVertex(Matrix4f matrix, float x, float y, float z) {
        float m00 = matrix.m00();
        float m10 = matrix.m10();
        float m20 = matrix.m20();
        float m30 = matrix.m30();
        float m01 = matrix.m01();
        float m11 = matrix.m11();
        float m21 = matrix.m21();
        float m31 = matrix.m31();
        float m02 = matrix.m02();
        float m12 = matrix.m12();
        float m22 = matrix.m22();
        float m32 = matrix.m32();
        float xt = m00 * x + m10 * y + m20 * z + m30;
        float yt = m01 * x + m11 * y + m21 * z + m31;
        float zt = m02 * x + m12 * y + m22 * z + m32;
        return ((VertexConsumer)this).addVertex(xt, yt, zt);
    }

    @Overwrite
    default public VertexConsumer setNormal(PoseStack.Pose pose, float x, float y, float z) {
        Matrix3f matrix = pose.normal();
        float m00 = matrix.m00();
        float m10 = matrix.m10();
        float m20 = matrix.m20();
        float m01 = matrix.m01();
        float m11 = matrix.m11();
        float m21 = matrix.m21();
        float m02 = matrix.m02();
        float m12 = matrix.m12();
        float m22 = matrix.m22();
        float xt = m00 * x + m10 * y + m20 * z;
        float yt = m01 * x + m11 * y + m21 * z;
        float zt = m02 * x + m12 * y + m22 * z;
        PoseStackPoseAccessor poseAccessor = (PoseStackPoseAccessor)pose;
        if (!poseAccessor.isTrustedNormals()) {
            return this.tritium$setNormalNormalized(xt, yt, zt);
        }
        return ((VertexConsumer)this).setNormal(xt, yt, zt);
    }

    @Unique
    private VertexConsumer tritium$setNormalNormalized(float x, float y, float z) {
        float lenSq = Math.fma((float)x, (float)x, (float)Math.fma((float)y, (float)y, (float)(z * z)));
        if (lenSq < 1.0E-8f) {
            return ((VertexConsumer)this).setNormal(0.0f, 1.0f, 0.0f);
        }
        if (lenSq > 0.999f && lenSq < 1.001f) {
            return ((VertexConsumer)this).setNormal(x, y, z);
        }
        float invLen = Math.invsqrt((float)lenSq);
        return ((VertexConsumer)this).setNormal(x * invLen, y * invLen, z * invLen);
    }
}

