/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.create;

import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Train.class})
public class TrainEntitiesMixin {
    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Ljava/util/List;forEach(Ljava/util/function/Consumer;)V"), remap=false)
    private void redirectCarriageEntityManagement(List<Carriage> carriages, Consumer<? super Carriage> action, Level level) {
        if (TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().execute(() -> {
                for (Carriage carriage : carriages) {
                    carriage.manageEntities(level);
                }
            });
        } else {
            carriages.forEach(action);
        }
    }
}

