/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.entity.stack.item;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Unique
    private static final int DEFAULT_MAX_STACK = 2147483547;
    @Unique
    private int tritium$lastMergeTick = -1;

    @Shadow
    public abstract ItemStack getItem();

    @Shadow
    public abstract void setItem(ItemStack var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        if (this.tritium$shouldAttemptMerge(self)) {
            this.tritium$lastMergeTick = (int)self.level().getGameTime();
            this.tritium$tryMergeItems(self);
        }
    }

    @Inject(method={"setItem"}, at={@At(value="TAIL")})
    private void onSetItem(ItemStack stack, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.tritium$updateStackDisplay(self);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private void onConstructor(Level level, double x, double y, double z, ItemStack stack, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.tritium$updateStackDisplay(self);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="TAIL")})
    private void onConstructorWithVelocity(Level level, double x, double y, double z, ItemStack stack, double dx, double dy, double dz, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.tritium$updateStackDisplay(self);
    }

    @Unique
    private boolean tritium$shouldProcess() {
        return TritiumConfigBase.Entities.EntityStacking.enable;
    }

    @Unique
    private boolean tritium$shouldAttemptMerge(ItemEntity self) {
        long gameTime = self.level().getGameTime();
        return this.tritium$lastMergeTick == -1 || gameTime - (long)this.tritium$lastMergeTick >= (long)TritiumConfigBase.Entities.EntityStacking.mergeCooldown;
    }

    @Unique
    private void tritium$tryMergeItems(ItemEntity self) {
        if (!TritiumConfigBase.Entities.EntityStacking.enable) {
            return;
        }
        ItemStack stack = self.getItem();
        int maxStack = this.tritium$getEffectiveMaxStackSize();
        if (stack.getCount() >= maxStack) {
            return;
        }
        List<ItemEntity> nearby = this.tritium$findMergeableItems(self);
        if (nearby.isEmpty()) {
            return;
        }
        this.tritium$performMerge(self, stack, maxStack, nearby);
    }

    @Unique
    private int tritium$getEffectiveMaxStackSize() {
        int configMax = TritiumConfigBase.Entities.EntityStacking.maxStackSize;
        return configMax > 0 ? configMax : 2147483547;
    }

    @Unique
    private List<ItemEntity> tritium$findMergeableItems(ItemEntity self) {
        double mergeDistance = TritiumConfigBase.Entities.EntityStacking.mergeDistance;
        int listMode = TritiumConfigBase.Entities.EntityStacking.listMode;
        List<String> itemList = TritiumConfigBase.Entities.EntityStacking.itemList;
        List nearby = self.level().getEntitiesOfClass(ItemEntity.class, self.getBoundingBox().inflate(mergeDistance), e -> this.tritium$isValidMergeTarget(self, (ItemEntity)e, listMode, (List<? extends String>)itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((ItemEntity)self).distanceToSqr(arg_0)));
        return nearby;
    }

    @Unique
    private void tritium$performMerge(ItemEntity self, ItemStack stack, int maxStack, List<ItemEntity> nearby) {
        int remainingSpace = maxStack - stack.getCount();
        for (ItemEntity other : nearby) {
            if (remainingSpace <= 0) break;
            ItemStack otherStack = other.getItem();
            int transfer = Math.min(otherStack.getCount(), remainingSpace);
            stack.grow(transfer);
            self.setItem(stack);
            self.setExtendedLifetime();
            this.tritium$handleOtherStackAfterTransfer(other, otherStack, transfer);
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void tritium$handleOtherStackAfterTransfer(ItemEntity other, ItemStack otherStack, int transfer) {
        if (otherStack.getCount() == transfer) {
            other.discard();
        } else {
            otherStack.shrink(transfer);
            other.setItem(otherStack);
            this.tritium$updateStackDisplay(other);
        }
    }

    @Unique
    private void tritium$updateStackDisplay(ItemEntity entity) {
        if (!TritiumConfigBase.Entities.EntityStacking.enable || !TritiumConfigBase.Entities.EntityStacking.showStackCount) {
            this.tritium$clearDisplay(entity);
            return;
        }
        ItemStack stack = entity.getItem();
        if (stack.getCount() > 1) {
            this.tritium$setStackCountDisplay(entity, stack.getCount());
        } else {
            this.tritium$clearDisplay(entity);
        }
    }

    @Unique
    private void tritium$setStackCountDisplay(ItemEntity entity, int count) {
        String currentText;
        Component currentName = entity.getCustomName();
        if (currentName != null && (currentText = currentName.getString()).startsWith("\u00d7") && currentText.length() > 1) {
            try {
                int currentCount = Integer.parseInt(currentText.substring(1));
                if (currentCount == count) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        MutableComponent countText = Component.literal((String)("\u00d7" + count)).withStyle(ChatFormatting.DARK_GREEN).withStyle(ChatFormatting.BOLD);
        entity.setCustomName((Component)countText);
        entity.setCustomNameVisible(true);
    }

    @Unique
    private void tritium$clearDisplay(ItemEntity entity) {
        entity.setCustomName(null);
        entity.setCustomNameVisible(false);
    }

    @Unique
    private boolean tritium$isValidMergeTarget(ItemEntity self, ItemEntity other, int listMode, List<? extends String> itemList) {
        ItemStack otherStack;
        if (self == other || other.isRemoved()) {
            return false;
        }
        ItemStack selfStack = self.getItem();
        return this.tritium$areItemsCompletelyIdentical(selfStack, otherStack = other.getItem()) && this.tritium$isMergeAllowed(otherStack, listMode, itemList) && (!TritiumConfigBase.Entities.EntityStacking.lockMaxedStacks || otherStack.getCount() < this.tritium$getEffectiveMaxStackSize());
    }

    @Unique
    private boolean tritium$areItemsCompletelyIdentical(ItemStack a, ItemStack b) {
        if (!ItemStack.isSameItem((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b)) {
            return false;
        }
        ItemEnchantments enchantmentsA = (ItemEnchantments)a.get(DataComponents.ENCHANTMENTS);
        ItemEnchantments enchantmentsB = (ItemEnchantments)b.get(DataComponents.ENCHANTMENTS);
        if (enchantmentsA != null && enchantmentsB != null ? !enchantmentsA.equals((Object)enchantmentsB) : enchantmentsA != enchantmentsB) {
            return false;
        }
        if (a.has(DataComponents.CUSTOM_NAME) && b.has(DataComponents.CUSTOM_NAME) ? !Objects.requireNonNull((Component)a.get(DataComponents.CUSTOM_NAME)).equals(b.get(DataComponents.CUSTOM_NAME)) : a.has(DataComponents.CUSTOM_NAME) != b.has(DataComponents.CUSTOM_NAME)) {
            return false;
        }
        return Arrays.equals(a.getTags().toArray(), b.getTags().toArray());
    }

    @Unique
    private boolean tritium$isMergeAllowed(ItemStack stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 == inList;
    }
}

