/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.jigsaw;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={JigsawBlockEntity.class})
public class JigsawBlockEntityMixin {
    @Inject(method={"generate"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeJigsawGeneration(ServerLevel level, int maxDepth, boolean keepJigsaws, CallbackInfo ci) {
        JigsawBlockEntity.JointType joint;
        Direction facing;
        BlockPos checkPos;
        if (!TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations || !TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawGenerationCheck) {
            return;
        }
        JigsawBlockEntity self = (JigsawBlockEntity)this;
        BlockPos pos = self.getBlockPos();
        BlockState state = self.getBlockState();
        if (state.hasProperty((Property)BlockStateProperties.FACING) && !level.isEmptyBlock(checkPos = pos.relative(facing = (Direction)state.getValue((Property)BlockStateProperties.FACING)))) {
            boolean hasSpace = false;
            for (int i = 1; i <= 3; ++i) {
                if (!level.isEmptyBlock(checkPos.relative(facing, i))) continue;
                hasSpace = true;
                break;
            }
            if (!hasSpace) {
                ci.cancel();
                return;
            }
        }
        if ((joint = self.getJoint()) != null && joint != JigsawBlockEntity.JointType.ALIGNED && joint != JigsawBlockEntity.JointType.ROLLABLE) {
            ci.cancel();
        }
    }
}

