/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.util;

import com.simibubi.create.Create;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.platform.Services;
import org.craftamethyst.tritium.util.SingleTaskLane;

public final class RailOffloaderHub {
    private static SingleTaskLane worker;
    private static volatile Future<?> currentFuture;
    private static boolean initialized;
    private static final boolean CREATE_LOADED;

    public static void initialize() {
        if (initialized || !CREATE_LOADED) {
            return;
        }
        if (!TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading) {
            return;
        }
        worker = new SingleTaskLane("TritiumRailWorker");
        initialized = true;
        TritiumCommon.LOG.info("Tritium rail offloader initialized");
    }

    public static void shutdown() {
        if (!CREATE_LOADED) {
            return;
        }
        initialized = false;
        if (worker != null) {
            worker.shutdown();
            worker = null;
        }
    }

    public static void onTickStart(MinecraftServer server) {
        if (!CREATE_LOADED || !initialized || worker == null) {
            return;
        }
        if (!TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading) {
            return;
        }
        ServerLevel overworld = server.overworld();
        currentFuture = worker.submit(() -> {
            try {
                Create.RAILWAYS.tick((Level)overworld);
            }
            catch (Exception e) {
                TritiumCommon.LOG.error("Error in rail offloader tick", (Throwable)e);
            }
        });
    }

    public static void onTickEnd() {
        if (!CREATE_LOADED || currentFuture == null) {
            return;
        }
        try {
            currentFuture.get(100L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            TritiumCommon.LOG.warn("Rail tick took too long, skipping sync");
            currentFuture.cancel(true);
        }
        finally {
            currentFuture = null;
        }
    }

    static {
        initialized = false;
        CREATE_LOADED = Services.PLATFORM.isModLoaded("create");
    }
}

