/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.compat.plugin;

import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CompatPlugin
implements IMixinConfigPlugin {
    private static final String IMMEDIATELY_FAST_MODID = "immediatelyfast";
    private static final String ENTITY_TEXTURE_FEATURES_MODID = "entity_texture_features";
    private static final String BBS_MODID = "bbs";
    private static final String VERTEX_BUFFER_MIXIN = "org.craftamethyst.tritium.mixin.client.renderer.vertex.VertexBufferMixin";
    private static final String FAST_BLIT_MIXIN = "org.craftamethyst.tritium.mixin.client.renderer.fast_blit.FastBlit";
    private Boolean hasImmFast;
    private Boolean hasETF;
    private Boolean hasBBS;

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.equals(VERTEX_BUFFER_MIXIN)) {
            return !this.shouldDisableVertexBufferMixin();
        }
        if (mixinClassName.equals(FAST_BLIT_MIXIN)) {
            return !this.shouldDisableFastBlitMixin();
        }
        return true;
    }

    private boolean shouldDisableVertexBufferMixin() {
        if (this.hasImmFast == null || this.hasETF == null) {
            this.hasImmFast = FabricLoader.getInstance().isModLoaded(IMMEDIATELY_FAST_MODID);
            this.hasETF = FabricLoader.getInstance().isModLoaded(ENTITY_TEXTURE_FEATURES_MODID);
            if (this.hasImmFast.booleanValue() || this.hasETF.booleanValue()) {
                System.out.println("[Tritium Compat] Disabling VertexBufferMixin due to compatibility with: " + (this.hasImmFast != false ? "ImmediatelyFast" : "") + (this.hasETF.booleanValue() ? (this.hasImmFast.booleanValue() ? "/ETF" : "ETF") : ""));
            }
        }
        return this.hasImmFast != false || this.hasETF != false;
    }

    private boolean shouldDisableFastBlitMixin() {
        if (this.hasBBS == null) {
            this.hasBBS = FabricLoader.getInstance().isModLoaded(BBS_MODID);
            if (this.hasBBS.booleanValue()) {
                System.out.println("[Tritium Compat] Disabling FastBlit due to compatibility issues with BBS screen recording");
            }
        }
        return this.hasBBS;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

