/*
 * Decompiled with CFR 0.152.
 */
package dev.asym.yetanotherdiscordintegration;

import com.electronwill.nightconfig.core.file.FileConfig;
import dev.asym.yetanotherdiscordintegration.YetAnotherDiscordIntegration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ConfigManager {
    private final Path configPath = Paths.get("config/yadi.toml", new String[0]);
    private String token = "";
    private String channelId = "";
    private String adminId = "";

    public void load() {
        Path configPath = Path.of("config", new String[0]);
        if (Files.notExists(configPath, new LinkOption[0])) {
            try {
                Files.createDirectories(configPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileConfig cfg = FileConfig.of(this.configPath);){
            cfg.load();
            if (!cfg.contains("discord.token")) {
                cfg.set("discord.token", (Object)"");
            }
            if (!cfg.contains("discord.channel_id")) {
                cfg.set("discord.channel_id", (Object)"");
            }
            if (!cfg.contains("discord.admin_id")) {
                cfg.set("discord.admin_id", (Object)"");
            }
            cfg.save();
            this.token = (String)cfg.get("discord.token");
            this.channelId = (String)cfg.get("discord.channel_id");
            this.adminId = (String)cfg.get("discord.admin_id");
        }
        catch (Exception e) {
            YetAnotherDiscordIntegration.LOGGER.error("Error loading config", e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getAdminId() {
        return this.adminId;
    }
}

