/*
 * Decompiled with CFR 0.152.
 */
package dev.asym.yetanotherdiscordintegration;

import com.mojang.brigadier.CommandDispatcher;
import dev.asym.yetanotherdiscordintegration.YetAnotherDiscordIntegration;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class DiscordHandler
extends ListenerAdapter {
    private final String token;
    private final String channelId;
    private TextChannel channel;
    private int tickCount = 0;

    public DiscordHandler(String token, String channelId) {
        this.token = token;
        this.channelId = channelId;
    }

    public void start() {
        try {
            JDA jda = JDABuilder.createDefault(this.token).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).addEventListeners(this).build();
            jda.awaitReady();
            this.channel = jda.getTextChannelById(this.channelId);
            jda.updateCommands().addCommands(Commands.slash("exec", "Run a Minecraft command on the server").addOption(OptionType.STRING, "command", "The command to execute", true)).queue();
            ServerTickEvents.START_SERVER_TICK.register(server -> {
                ++this.tickCount;
                if (this.tickCount % 200 == 0) {
                    int online = server.method_3760().method_14571().size();
                    jda.getPresence().setActivity(Activity.customStatus(online + " player" + (online == 1 ? "" : "s") + " online"));
                }
            });
        }
        catch (Exception e) {
            YetAnotherDiscordIntegration.LOGGER.warn("Discord connection failed", e);
        }
    }

    public void sendToDiscord(String msg) {
        if (this.channel != null) {
            this.channel.sendMessage(msg).queue();
        }
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent e) {
        if (e.getAuthor().isBot()) {
            return;
        }
        if (!e.getChannel().getId().equals(this.channelId)) {
            return;
        }
        YetAnotherDiscordIntegration.sendToMinecraft(e.getAuthor().getName() + ": " + e.getMessage().getContentDisplay());
    }

    @Override
    public void onSlashCommandInteraction(SlashCommandInteractionEvent e) {
        if (!e.getName().equals("exec")) {
            return;
        }
        String userId = e.getUser().getId();
        if (!userId.equals(YetAnotherDiscordIntegration.config.getAdminId())) {
            e.reply("You are not authorized to use this command.").setEphemeral(true).queue();
            return;
        }
        String cmd = e.getOption("command").getAsString();
        e.deferReply(true).queue();
        YetAnotherDiscordIntegration.server.execute(() -> {
            try {
                CommandDispatcher dispatcher = YetAnotherDiscordIntegration.server.method_3734().method_9235();
                final StringBuilder buffer = new StringBuilder();
                class_2168 source2 = YetAnotherDiscordIntegration.server.method_3739().method_36321(new class_2165(){

                    public void method_43496(class_2561 message) {
                        buffer.append(message.getString()).append("\n");
                    }

                    public boolean method_9200() {
                        return true;
                    }

                    public boolean method_9202() {
                        return false;
                    }

                    public boolean method_9201() {
                        return true;
                    }
                });
                dispatcher.execute(cmd, (Object)source2);
                String output = !buffer.isEmpty() ? buffer.toString() : "(no output captured, could be an async output)";
                String msg = "\n```\n" + output.strip() + "\n```";
                if (msg.length() > 1900) {
                    msg = msg.substring(0, 1900) + "\n```(truncated)```";
                }
                e.getHook().sendMessage(msg).queue();
            }
            catch (Exception ex) {
                e.getHook().sendMessage("Error executing: `" + ex.getMessage() + "`").queue();
            }
        });
    }
}

