/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components.thumbnail;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.ResolvedMedia;
import net.dv8tion.jda.api.components.section.SectionAccessoryComponent;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.internal.components.thumbnail.ThumbnailFileUpload;
import net.dv8tion.jda.internal.components.thumbnail.ThumbnailImpl;
import net.dv8tion.jda.internal.utils.Checks;

public interface Thumbnail
extends SectionAccessoryComponent {
    public static final int MAX_DESCRIPTION_LENGTH = 1024;

    @Nonnull
    public static Thumbnail fromUrl(@Nonnull String url) {
        Checks.notBlank(url, "URL");
        return new ThumbnailImpl(url);
    }

    @Nonnull
    public static Thumbnail fromFile(@Nonnull FileUpload file) {
        Checks.notNull(file, "FileUpload");
        return new ThumbnailFileUpload(file);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public Thumbnail withUniqueId(int var1);

    @Nonnull
    @CheckReturnValue
    public Thumbnail withDescription(@Nullable String var1);

    @Nonnull
    @CheckReturnValue
    public Thumbnail withSpoiler(boolean var1);

    @Nonnull
    public String getUrl();

    @Nullable
    public ResolvedMedia getResolvedMedia();

    @Nullable
    public String getDescription();

    public boolean isSpoiler();
}

