/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.components.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.Component;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.container.Container;
import net.dv8tion.jda.api.components.section.Section;
import net.dv8tion.jda.api.components.section.SectionContentComponentUnion;

public class ComponentIterator
implements Iterator<Component> {
    private final Deque<Iterator<? extends Component>> stack = new ArrayDeque<Iterator<? extends Component>>();

    protected ComponentIterator(Collection<? extends Component> components) {
        this.stack.push(components.iterator());
    }

    @Nonnull
    public static ComponentIterator create(@Nonnull Collection<? extends Component> components) {
        return new ComponentIterator(components);
    }

    @Nonnull
    public static Stream<Component> createStream(@Nonnull Collection<? extends Component> components) {
        Spliterator<Component> spliterator = Spliterators.spliteratorUnknownSize(ComponentIterator.create(components), 16);
        return StreamSupport.stream(spliterator, false);
    }

    @Override
    public boolean hasNext() {
        this.ensureNestedIteratorHasNext();
        return !this.stack.isEmpty();
    }

    @Override
    @Nonnull
    public Component next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator<? extends Component> iterator2 = this.stack.peek();
        Component component = iterator2.next();
        Iterator<? extends Component> childrenIterator = ComponentIterator.getIteratorForComponent(component);
        if (childrenIterator != null) {
            this.stack.push(childrenIterator);
        }
        return component;
    }

    private void ensureNestedIteratorHasNext() {
        while (!this.stack.isEmpty() && !this.stack.peek().hasNext()) {
            this.stack.pop();
        }
    }

    @Nullable
    private static Iterator<? extends Component> getIteratorForComponent(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            return container.getComponents().iterator();
        }
        if (component instanceof ActionRow) {
            ActionRow actionRow = (ActionRow)component;
            return actionRow.getComponents().iterator();
        }
        if (component instanceof Section) {
            Section section = (Section)component;
            ArrayList<SectionContentComponentUnion> sectionComponents = new ArrayList<SectionContentComponentUnion>(section.getContentComponents());
            sectionComponents.add((SectionContentComponentUnion)((Object)section.getAccessory()));
            return sectionComponents.iterator();
        }
        return null;
    }
}

