/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils.messages;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.MessageTopLevelComponentUnion;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.data.DataArray;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.api.utils.data.SerializableData;
import net.dv8tion.jda.api.utils.messages.AllowedMentionsData;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageData;
import net.dv8tion.jda.api.utils.messages.MessageEditBuilder;
import net.dv8tion.jda.internal.utils.Helpers;
import net.dv8tion.jda.internal.utils.IOUtil;
import net.dv8tion.jda.internal.utils.message.MessageUtil;

public class MessageEditData
implements MessageData,
AutoCloseable,
SerializableData {
    protected final AllowedMentionsData mentions;
    private final String content;
    private final List<MessageEmbed> embeds;
    private final List<AttachedFile> files;
    private final Set<AttachedFile> allDistinctFiles;
    private final List<MessageTopLevelComponentUnion> components;
    private final int messageFlags;
    private final boolean isReplace;
    private final int configuredFields;

    protected MessageEditData(int configuredFields, int messageFlags, boolean isReplace, String content, List<MessageEmbed> embeds, List<AttachedFile> files, List<MessageTopLevelComponentUnion> components, AllowedMentionsData mentions) {
        this.content = content;
        this.embeds = Collections.unmodifiableList(embeds);
        this.files = Collections.unmodifiableList(files);
        this.allDistinctFiles = MessageEditData.createAllDistinctFiles(files, components);
        this.components = Collections.unmodifiableList(components);
        this.mentions = mentions;
        this.messageFlags = messageFlags;
        this.isReplace = isReplace;
        this.configuredFields = configuredFields;
    }

    @Nonnull
    public static MessageEditData fromContent(@Nonnull String content) {
        return new MessageEditBuilder().setContent(content).build();
    }

    @Nonnull
    public static MessageEditData fromEmbeds(@Nonnull Collection<? extends MessageEmbed> embeds) {
        return ((MessageEditBuilder)new MessageEditBuilder().setEmbeds((Collection)embeds)).build();
    }

    @Nonnull
    public static MessageEditData fromEmbeds(MessageEmbed ... embeds) {
        return ((MessageEditBuilder)new MessageEditBuilder().setEmbeds(embeds)).build();
    }

    @Nonnull
    public static MessageEditData fromFiles(@Nonnull Collection<? extends FileUpload> files) {
        return ((MessageEditBuilder)new MessageEditBuilder().setFiles(files)).build();
    }

    @Nonnull
    public static MessageEditData fromFiles(FileUpload ... files) {
        return ((MessageEditBuilder)new MessageEditBuilder().setFiles(files)).build();
    }

    @Nonnull
    public static MessageEditData fromMessage(@Nonnull Message message) {
        return ((MessageEditBuilder)new MessageEditBuilder().applyMessage(message)).build();
    }

    @Nonnull
    public static MessageEditData fromCreateData(@Nonnull MessageCreateData data) {
        return ((MessageEditBuilder)new MessageEditBuilder().applyCreateData(data)).build();
    }

    protected boolean isReplace() {
        return this.isReplace;
    }

    protected int getConfiguredFields() {
        return this.configuredFields;
    }

    protected int getFlags() {
        return this.messageFlags;
    }

    @Override
    @Nonnull
    public String getContent() {
        return this.content;
    }

    @Override
    @Nonnull
    public List<MessageEmbed> getEmbeds() {
        return this.embeds;
    }

    @Override
    @Nonnull
    public List<MessageTopLevelComponentUnion> getComponents() {
        return this.components;
    }

    @Override
    public boolean isUsingComponentsV2() {
        return (this.messageFlags & Message.MessageFlag.IS_COMPONENTS_V2.getValue()) != 0;
    }

    @Nonnull
    public List<AttachedFile> getAttachments() {
        return this.files;
    }

    @Override
    public boolean isSuppressEmbeds() {
        return this.isSet(Message.MessageFlag.EMBEDS_SUPPRESSED.getValue());
    }

    @Override
    @Nonnull
    public Set<String> getMentionedUsers() {
        return this.mentions.getMentionedUsers();
    }

    @Override
    @Nonnull
    public Set<String> getMentionedRoles() {
        return this.mentions.getMentionedRoles();
    }

    @Override
    @Nonnull
    public EnumSet<Message.MentionType> getAllowedMentions() {
        return this.mentions.getAllowedMentions();
    }

    @Override
    public boolean isMentionRepliedUser() {
        return this.mentions.isMentionRepliedUser();
    }

    @Override
    @Nonnull
    public synchronized DataObject toData() {
        DataObject json = DataObject.empty();
        if (this.isSet(1)) {
            json.put("content", this.content);
        }
        if (this.isSet(2)) {
            json.put("embeds", DataArray.fromCollection(this.embeds));
        }
        if (this.isSet(4)) {
            json.put("components", DataArray.fromCollection(this.components));
        }
        if (this.isSet(16)) {
            json.put("allowed_mentions", this.mentions);
        }
        if (this.isSet(32)) {
            json.put("flags", this.messageFlags);
        }
        List<FileUpload> additionalFiles = MessageUtil.getIndirectFiles(this.components);
        if (this.isSet(8) || !additionalFiles.isEmpty()) {
            json.put("attachments", MessageUtil.getAttachmentsData(this.allDistinctFiles));
        }
        return json;
    }

    @Nonnull
    public synchronized List<FileUpload> getFiles() {
        return this.files.stream().filter(FileUpload.class::isInstance).map(FileUpload.class::cast).collect(Helpers.toUnmodifiableList());
    }

    @Nonnull
    public Set<? extends AttachedFile> getAllDistinctFiles() {
        return this.allDistinctFiles;
    }

    @Nonnull
    public static Set<AttachedFile> createAllDistinctFiles(@Nullable Collection<AttachedFile> files, @Nonnull Collection<MessageTopLevelComponentUnion> components) {
        List<FileUpload> indirectFiles = MessageUtil.getIndirectFiles(components);
        LinkedHashSet<AttachedFile> distinctFiles = new LinkedHashSet<AttachedFile>((files == null ? 0 : files.size()) + indirectFiles.size());
        if (files != null) {
            distinctFiles.addAll(files);
        }
        distinctFiles.addAll(indirectFiles);
        return Collections.unmodifiableSet(distinctFiles);
    }

    @Override
    public synchronized void close() {
        this.files.forEach(IOUtil::silentClose);
    }

    protected boolean isSet(int flag) {
        return this.isReplace || (this.configuredFields & flag) != 0;
    }
}

