/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.utils.messages;

import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.utils.AttachedFile;
import net.dv8tion.jda.api.utils.FileUpload;
import net.dv8tion.jda.api.utils.messages.MessageCreateData;
import net.dv8tion.jda.api.utils.messages.MessageEditData;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import net.dv8tion.jda.internal.utils.Checks;

public interface MessageEditRequest<R extends MessageEditRequest<R>>
extends MessageRequest<R> {
    @Nonnull
    public R setAttachments(@Nullable Collection<? extends AttachedFile> var1);

    @Nonnull
    default public R setAttachments(AttachedFile ... attachments) {
        Checks.noneNull(attachments, "Attachments");
        return this.setAttachments(Arrays.asList(attachments));
    }

    @Override
    @Nonnull
    default public R setFiles(@Nullable Collection<? extends FileUpload> files) {
        return this.setAttachments(files);
    }

    @Nonnull
    public R setReplace(boolean var1);

    public boolean isReplace();

    @Nonnull
    public R applyData(@Nonnull MessageEditData var1);

    @Nonnull
    default public R applyCreateData(@Nonnull MessageCreateData data) {
        return (R)((MessageEditRequest)((MessageEditRequest)((MessageEditRequest)((MessageEditRequest)((MessageEditRequest)((MessageEditRequest)((MessageEditRequest)((MessageEditRequest)this.setReplace(true).setContent(data.getContent())).setAllowedMentions(data.getAllowedMentions())).mentionUsers(data.getMentionedUsers())).mentionRoles(data.getMentionedRoles())).mentionRepliedUser(data.isMentionRepliedUser())).setComponents(data.getComponents())).useComponentsV2(data.isUsingComponentsV2())).setEmbeds(data.getEmbeds())).setFiles(data.getFiles());
    }

    @Override
    @Nonnull
    default public R applyMessage(@Nonnull Message message) {
        Checks.notNull(message, "Message");
        Checks.check(!message.getType().isSystem(), "Cannot copy a system message");
        return this.applyCreateData(MessageCreateData.fromMessage(message));
    }
}

