/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.internal.components.textinput;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.components.actionrow.ActionRowChildComponentUnion;
import net.dv8tion.jda.api.components.textinput.TextInput;
import net.dv8tion.jda.api.components.textinput.TextInputStyle;
import net.dv8tion.jda.api.utils.data.DataObject;
import net.dv8tion.jda.internal.components.AbstractComponentImpl;
import net.dv8tion.jda.internal.utils.Checks;
import net.dv8tion.jda.internal.utils.EntityString;

public class TextInputImpl
extends AbstractComponentImpl
implements TextInput,
ActionRowChildComponentUnion {
    private final String id;
    private final int uniqueId;
    private final TextInputStyle style;
    private final String label;
    private final int minLength;
    private final int maxLength;
    private final boolean required;
    private final String value;
    private final String placeholder;

    public TextInputImpl(DataObject object) {
        this(object.getString("custom_id"), object.getInt("id"), TextInputStyle.fromKey(object.getInt("style", -1)), object.getString("label", null), object.getInt("min_length", -1), object.getInt("max_length", -1), object.getBoolean("required", true), object.getString("value", null), object.getString("placeholder", null));
    }

    public TextInputImpl(String id, int uniqueId, TextInputStyle style, String label, int minLength, int maxLength, boolean required, String value, String placeholder) {
        this.id = id;
        this.uniqueId = uniqueId;
        this.style = style;
        this.label = label;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.required = required;
        this.value = value;
        this.placeholder = placeholder;
    }

    @Override
    @Nonnull
    public TextInputImpl withUniqueId(int uniqueId) {
        Checks.positive(uniqueId, "Unique ID");
        return new TextInputImpl(this.id, uniqueId, this.style, this.label, this.minLength, this.maxLength, this.required, this.value, this.placeholder);
    }

    @Override
    @Nonnull
    public TextInputStyle getStyle() {
        return this.style;
    }

    @Override
    @Nonnull
    public String getCustomId() {
        return this.id;
    }

    @Override
    public int getUniqueId() {
        return this.uniqueId;
    }

    @Override
    @Nonnull
    public String getLabel() {
        return this.label;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    @Nullable
    public String getValue() {
        return this.value;
    }

    @Override
    @Nullable
    public String getPlaceHolder() {
        return this.placeholder;
    }

    @Override
    @Nonnull
    public DataObject toData() {
        DataObject obj = DataObject.empty().put("type", this.getType().getKey()).put("custom_id", this.id).put("style", this.style.getRaw()).put("required", this.required).put("label", this.label);
        if (this.minLength != -1) {
            obj.put("min_length", this.minLength);
        }
        if (this.maxLength != -1) {
            obj.put("max_length", this.maxLength);
        }
        if (this.value != null) {
            obj.put("value", this.value);
        }
        if (this.placeholder != null) {
            obj.put("placeholder", this.placeholder);
        }
        return obj;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextInputImpl)) {
            return false;
        }
        TextInputImpl that = (TextInputImpl)o;
        return this.uniqueId == that.uniqueId && this.minLength == that.minLength && this.maxLength == that.maxLength && this.required == that.required && this.id.equals(that.id) && this.style == that.style && this.label.equals(that.label) && Objects.equals(this.value, that.value) && Objects.equals(this.placeholder, that.placeholder);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.uniqueId, this.style, this.label, this.minLength, this.maxLength, this.required, this.value, this.placeholder});
    }

    public String toString() {
        return new EntityString(this).setType(this.style).addMetadata("id", this.id).addMetadata("value", this.value).toString();
    }
}

