/*
 * Decompiled with CFR 0.152.
 */
package com.everydayxp.raidlure.item;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class RaidLureItem
extends Item {
    public RaidLureItem(Item.Properties properties) {
        super(properties);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 60;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(hand));
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        Player player;
        block6: {
            block5: {
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (!level.f_46443_) break block6;
            }
            return stack;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos pos = player.m_20183_();
        Raid raid = serverLevel.m_8832_(pos);
        if (raid == null || raid.m_37762_()) {
            player.m_5661_((Component)Component.m_237115_((String)"item.raidlure.raid_lure.fail"), true);
            return stack;
        }
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
        scheduler.schedule(() -> serverLevel.m_7654_().execute(() -> {
            Advancement advancement;
            ServerPlayer serverPlayer;
            MinecraftServer server;
            serverLevel.m_5594_(null, pos, SoundEvents.f_11700_, SoundSource.PLAYERS, 2.0f, 1.0f);
            int teleported = this.teleportRaiders(serverLevel, pos, raid, player);
            if (teleported == 0) {
                player.m_5661_((Component)Component.m_237115_((String)"item.raidlure.raid_lure.no_raiders"), true);
                return;
            }
            player.m_36335_().m_41524_((Item)this, 100);
            player.m_5661_((Component)Component.m_237115_((String)"item.raidlure.cooldown"), true);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175827_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 100, 1.5, 1.0, 1.5, 0.05);
            List raiders = serverLevel.m_45976_(Raider.class, new AABB(pos).m_82400_(100.0));
            for (Raider raider : raiders) {
                if (!raider.m_6084_() || raider.m_37885_() != raid) continue;
                raider.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 100, 0));
            }
            player.m_5661_((Component)Component.m_237110_((String)"item.raidlure.raid_lure.success", (Object[])new Object[]{teleported}), true);
            if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).m_20194_()) != null && (advancement = server.m_129889_().m_136041_(new ResourceLocation("raidlure", "teleported_raid"))) != null) {
                serverPlayer.m_8960_().m_135988_(advancement, "used");
            }
        }), 1L, TimeUnit.SECONDS);
        return stack;
    }

    private int teleportRaiders(ServerLevel level, BlockPos pos, Raid raid, Player player) {
        List raiders = level.m_45976_(Raider.class, new AABB(pos).m_82400_(100.0));
        int teleported = 0;
        for (Raider raider : raiders) {
            if (!raider.m_6084_() || raider.m_37885_() != raid) continue;
            double angle = Math.random() * 2.0 * Math.PI;
            double radius = 5.0;
            double offsetX = player.m_20185_() + radius * Math.cos(angle);
            double offsetZ = player.m_20189_() + radius * Math.sin(angle);
            double offsetY = player.m_20186_();
            raider.m_6021_(offsetX, offsetY, offsetZ);
            ++teleported;
        }
        return teleported;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.raidlure.raid_lure.tooltip.1"));
        tooltip.add((Component)Component.m_237115_((String)"item.raidlure.raid_lure.tooltip.2"));
        tooltip.add((Component)Component.m_237115_((String)"item.raidlure.raid_lure.tooltip.3"));
    }
}

