/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.castirongrill.client.screen;

import com.hermitowo.castirongrill.CastIronGrill;
import com.hermitowo.castirongrill.common.blockentities.CastIronGrillBlockEntity;
import com.hermitowo.castirongrill.common.container.CastIronGrillContainer;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.screen.BlockEntityScreen;
import net.dries007.tfc.common.component.heat.Heat;
import net.dries007.tfc.common.container.BlockEntityContainer;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.TemperatureDisplayStyle;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class CastIronGrillScreen
extends BlockEntityScreen<CastIronGrillBlockEntity, CastIronGrillContainer> {
    private static final ResourceLocation BACKGROUND = CastIronGrill.rl("textures/gui/cast_iron_grill_firepit.png");

    public CastIronGrillScreen(CastIronGrillContainer container, Inventory playerInventory, Component name) {
        super((BlockEntityContainer)container, playerInventory, name, BACKGROUND);
        this.inventoryLabelY += 20;
        this.imageHeight += 20;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        int temp = Heat.scaleTemperatureForGui((float)((CastIronGrillBlockEntity)this.blockEntity).getTemperature());
        if (temp > 0) {
            graphics.blit(this.texture, this.leftPos + 30, this.topPos + 76 - Math.min(51, temp), 176, 0, 15, 5);
        }
    }

    protected void renderTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent text;
        super.renderTooltip(graphics, mouseX, mouseY);
        if (RenderHelpers.isInside((int)mouseX, (int)mouseY, (int)(this.leftPos + 30), (int)(this.topPos + 76 - 51), (int)15, (int)51) && (text = ((TemperatureDisplayStyle)TFCConfig.CLIENT.heatTooltipStyle.get()).formatColored(((CastIronGrillBlockEntity)this.blockEntity).getTemperature())) != null) {
            graphics.renderTooltip(this.font, (Component)text, mouseX, mouseY);
        }
    }
}

