/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.castirongrill.common.blockentities;

import com.hermitowo.castirongrill.common.blockentities.CIGBlockEntities;
import com.hermitowo.castirongrill.common.container.CastIronGrillContainer;
import java.util.function.Predicate;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.component.food.FoodCapability;
import net.dries007.tfc.common.component.food.FoodTraits;
import net.dries007.tfc.common.component.heat.HeatCapability;
import net.dries007.tfc.common.component.heat.IHeat;
import net.dries007.tfc.common.recipes.HeatingRecipe;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CastIronGrillBlockEntity
extends AbstractFirepitBlockEntity<ItemStackHandler> {
    public static final int SLOT_EXTRA_INPUT_START = 4;
    public static final int SLOT_EXTRA_INPUT_END = 5;
    private final HeatingRecipe[] cachedRecipes = new HeatingRecipe[2];

    public CastIronGrillBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CIGBlockEntities.CAST_IRON_GRILL.get(), pos, state, CastIronGrillBlockEntity.defaultInventory((int)6));
        if (((Boolean)TFCConfig.SERVER.firePitEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{3}).extract(new int[]{4, 5}), (Predicate)Direction.Plane.HORIZONTAL).on((Object)new PartialItemHandler(this.inventory).insert(new int[]{4, 5}), new Direction[]{Direction.UP});
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowID, Inventory playerInv, Player player) {
        return CastIronGrillContainer.create(this, playerInv, windowID);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot >= 4 && slot <= 5) {
            return HeatCapability.has((ItemStack)stack);
        }
        return super.isItemValid(slot, stack);
    }

    protected void handleCooking() {
        assert (this.level != null);
        for (int slot = 4; slot <= 5; ++slot) {
            ItemStack inputStack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            @Nullable IHeat inputHeat = HeatCapability.get((ItemStack)inputStack);
            if (inputHeat == null) continue;
            HeatCapability.addTemp((IHeat)inputHeat, (float)this.temperature);
            HeatingRecipe recipe = this.cachedRecipes[slot - 4];
            if (recipe == null || !recipe.isValidTemperature(inputHeat.getTemperature())) continue;
            ItemStack output = recipe.assembleItem(inputStack);
            FoodCapability.applyTrait((ItemStack)output, (Holder)FoodTraits.WOOD_GRILLED);
            ((ItemStackHandler)this.inventory).setStackInSlot(slot, output);
            this.markForSync();
        }
    }

    protected void coolInstantly() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            HeatCapability.setTemperature((ItemStack)stack, (float)0.0f);
        }
    }

    protected void updateCachedRecipe() {
        for (int slot = 4; slot <= 5; ++slot) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(slot);
            this.cachedRecipes[slot - 4] = stack.isEmpty() ? null : HeatingRecipe.getRecipe((ItemStack)stack);
        }
    }
}

