/*
 * Decompiled with CFR 0.152.
 */
package com.hermitowo.castirongrill.common.blocks.devices;

import com.hermitowo.castirongrill.common.blockentities.CIGBlockEntities;
import com.hermitowo.castirongrill.common.blockentities.CastIronGrillBlockEntity;
import com.hermitowo.castirongrill.common.items.CIGItems;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.stream.Collectors;
import net.dries007.tfc.client.IHighlightHandler;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.TFCDamageTypes;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.items.Powder;
import net.dries007.tfc.common.items.TFCItems;
import net.dries007.tfc.util.Helpers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CastIronGrillBlock
extends FirepitBlock
implements IHighlightHandler {
    private static final Map<Integer, VoxelShape> SLOT_RENDER_SHAPES = Map.of(5, Shapes.box((double)0.6, (double)0.65, (double)0.4, (double)0.8, (double)0.7, (double)0.6), 4, Shapes.box((double)0.2, (double)0.65, (double)0.4, (double)0.4, (double)0.7, (double)0.6));
    private static final Map<Integer, AABB> SLOT_BOUNDS = SLOT_RENDER_SHAPES.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((VoxelShape)entry.getValue()).bounds().inflate((double)0.01f)));
    public static final Map<Integer, Vec3> SLOT_CENTERS = SLOT_BOUNDS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((AABB)entry.getValue()).getCenter().multiply(1.0, 0.0, 1.0).add(0.0, 0.625, 0.0)));
    private static final VoxelShape GRILL_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)CastIronGrillBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0));

    public static int getSlotForSelection(BlockHitResult result) {
        Vec3 location = result.getLocation();
        BlockPos pos = result.getBlockPos();
        for (Map.Entry<Integer, AABB> entry : SLOT_BOUNDS.entrySet()) {
            if (!entry.getValue().move(pos).contains(location)) continue;
            return entry.getKey();
        }
        return -1;
    }

    public CastIronGrillBlock(ExtendedProperties properties) {
        super(properties, GRILL_SHAPE);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.getBlockEntity(pos, (BlockEntityType)CIGBlockEntities.CAST_IRON_GRILL.get()).ifPresent(grill -> SLOT_CENTERS.forEach((slot, vec) -> {
                if (!((ItemStackHandler)grill.getInventory()).getStackInSlot(slot.intValue()).isEmpty() && random.nextFloat() < 0.4f) {
                    double x = vec.x + (double)pos.getX();
                    double y = vec.y + (double)pos.getY();
                    double z = vec.z + (double)pos.getZ();
                    level.playLocalSound(x, y, z, SoundEvents.FURNACE_FIRE_CRACKLE, SoundSource.BLOCKS, 0.25f, random.nextFloat() * 0.7f + 0.4f, false);
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
                }
            }));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CastIronGrillBlockEntity grill = level.getBlockEntity(pos, (BlockEntityType)CIGBlockEntities.CAST_IRON_GRILL.get()).orElse(null);
        if (grill != null) {
            ItemStack current;
            IItemHandlerModifiable inventory = grill.getInventory();
            int slot = CastIronGrillBlock.getSlotForSelection(hitResult);
            ItemStack itemStack = current = slot == -1 ? ItemStack.EMPTY : inventory.getStackInSlot(slot);
            if (!stack.isEmpty() && slot != -1 && current.isEmpty() && inventory.isItemValid(slot, stack)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inventory.insertItem(slot, stack.split(1), false));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.isEmpty() && slot != -1 && !current.isEmpty() && (!inventory.isItemValid(slot, current) || player.isShiftKeyDown())) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)inventory.extractItem(slot, 64, false));
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.isEmpty() && player.isShiftKeyDown()) {
                if (!level.isClientSide) {
                    if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)LIT)).booleanValue() && grill.getAsh() > 0) {
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)((TFCItems.ItemId)TFCItems.POWDERS.get(Powder.WOOD_ASH)).get(), grill.getAsh()));
                        grill.setAsh(0);
                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.SAND_BREAK);
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)CIGItems.CAST_IRON_GRILL.get()));
                    AbstractFirepitBlockEntity.convertTo((LevelAccessor)level, (BlockPos)pos, (BlockState)state, (AbstractFirepitBlockEntity)grill, (Block)((Block)TFCBlocks.FIREPIT.get()));
                    if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                        TFCDamageTypes.grill((Entity)player, (float)1.0f);
                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)((SoundEvent)TFCSounds.ITEM_COOL.get()));
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (CastIronGrillBlock.tryInsertLog((Player)player, (ItemStack)stack, (AbstractFirepitBlockEntity)grill, (hitResult.getLocation().y - (double)pos.getY() < 0.6 ? 1 : 0) != 0)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)grill, pos);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public boolean drawHighlight(Level level, BlockPos pos, Player player, BlockHitResult rayTrace, PoseStack stack, MultiBufferSource buffers, Vec3 rendererPosition) {
        int slot = CastIronGrillBlock.getSlotForSelection(rayTrace);
        if (slot != -1) {
            IHighlightHandler.drawBox((PoseStack)stack, (VoxelShape)SLOT_RENDER_SHAPES.get(slot), (MultiBufferSource)buffers, (BlockPos)pos, (Vec3)rendererPosition, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            return true;
        }
        return false;
    }

    public double getParticleHeightOffset() {
        return 0.8;
    }
}

