/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellish_chat.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.hanhy06.embellish_chat.config.ConfigManager;
import io.github.hanhy06.embellish_chat.message.MessageProcessor;
import java.util.Collection;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7471;

public class EmbellishChatCommand {
    public static void registerEmbellishChat() {
        CommandRegistrationCallback.EVENT.register((commandDispatcher, commandRegistryAccess, registrationEnvironment) -> commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"embellish_chat").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(EmbellishChatCommand::executeReloadConfig))).then(class_2170.method_9247((String)"ban").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(context -> EmbellishChatCommand.executeBanOrPardon((CommandContext<class_2168>)context, true))))).then(class_2170.method_9247((String)"pardon").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(context -> EmbellishChatCommand.executeBanOrPardon((CommandContext<class_2168>)context, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"test").then(class_2170.method_9247((String)"regex").then(class_2170.method_9244((String)"regex", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"test", (ArgumentType)StringArgumentType.string()).executes(EmbellishChatCommand::executeRegexTest))))).then(class_2170.method_9247((String)"stress").then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)"test", (ArgumentType)StringArgumentType.string()).executes(EmbellishChatCommand::executeStressTest)))))));
    }

    private static int executeReloadConfig(CommandContext<class_2168> context) {
        ConfigManager.INSTANCE.readConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Config reloaded successfully."), true);
        return 1;
    }

    private static int executeBanOrPardon(CommandContext<class_2168> context, boolean ban) throws CommandSyntaxException {
        Collection players = class_2186.method_9312(context, (String)"target");
        if (ban) {
            ConfigManager.getConfig().bannedPlayerList().addAll(players.stream().map(class_1297::method_5667).toList());
        } else {
            ConfigManager.getConfig().bannedPlayerList().removeAll(players.stream().map(class_1297::method_5667).toList());
        }
        ConfigManager.INSTANCE.writeConfig();
        String playerNames = players.stream().map(class_1657::method_5477).map(class_2561::getString).collect(Collectors.joining(", "));
        String action = ban ? "banned" : "pardoned";
        String result = String.format("Player(s) %s %s.", playerNames, action);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)result), true);
        return 1;
    }

    private static int executeRegexTest(CommandContext<class_2168> context) {
        Matcher matcher;
        String regexString = StringArgumentType.getString(context, (String)"regex");
        String testString = StringArgumentType.getString(context, (String)"test");
        try {
            Pattern pattern = Pattern.compile(regexString);
            matcher = pattern.matcher(testString);
        }
        catch (PatternSyntaxException e) {
            String error = String.format("Failed to compile regex: \"%s\" (%s)", regexString, e.getMessage());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)error), false);
            return 0;
        }
        if (!matcher.find()) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"No match found."), false);
            return 0;
        }
        String result = EmbellishChatCommand.formatMatchResult(matcher);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)result), false);
        return 1;
    }

    private static String formatMatchResult(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            return String.format("Matched (Group 1): %s", matcher.group(1));
        }
        if (groupCount == 2) {
            return String.format("Matched [Group 1: %s] | [Group 2: %s]", matcher.group(1), matcher.group(2));
        }
        return "Invalid regex or test string. (Requires 1 or 2 capture groups)";
    }

    private static int executeStressTest(CommandContext<class_2168> context) {
        int count = IntegerArgumentType.getInteger(context, (String)"count");
        String test = StringArgumentType.getString(context, (String)"test");
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Stress test must be run by a player in-game."), false);
            return 0;
        }
        if (count > 500) {
            source.method_9226(() -> class_2561.method_43470((String)"Count is too large. (Max 500)"), true);
            return 0;
        }
        class_7471 testMessage = class_7471.method_45098((UUID)player.method_5667(), (String)test);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < count; ++i) {
            MessageProcessor.INSTANCE.handleMessage(testMessage);
        }
        long duration = System.currentTimeMillis() - startTime;
        double messagesPerSecond = (double)count * 1000.0 / (double)duration;
        String result = String.format("Stress test complete: Processed %d messages in %dms (%.2f msg/s)", count, duration, messagesPerSecond);
        source.method_9226(() -> class_2561.method_43470((String)result), false);
        return 1;
    }
}

