/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat;

import com.hanhy06.embellish_chat.chat.processor.Mention;
import com.hanhy06.embellish_chat.chat.processor.StyledTextProcessor;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_7471;

public class ChatHandler
implements ConfigListener {
    public static ChatHandler INSTANCE;
    private Config config;
    private Mention mention;
    private final class_3324 manager;

    public ChatHandler(class_3324 manager, class_269 scoreboard) {
        INSTANCE = this;
        this.manager = manager;
        this.mention = new Mention(manager, scoreboard);
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.applyConfig(newConfig);
    }

    public class_7471 handleChatMessage(class_7471 original) {
        class_3222 sender = this.manager.method_14602(original.method_46292());
        class_5250 baseMessage = class_5250.method_43477((class_7417)original.method_46291().method_10851());
        String raw = original.method_46291().getString();
        List<Receiver> receivers = List.of();
        if (this.config.mentionEnabled()) {
            receivers = this.handleMentions(raw, sender);
        }
        class_5250 finalMessage = baseMessage;
        if (this.config.inChatStylingEnabled()) {
            finalMessage = StyledTextProcessor.applyStyles(this.config, baseMessage, receivers);
        }
        return original.method_44863((class_2561)finalMessage);
    }

    private List<Receiver> handleMentions(String raw, class_3222 sender) {
        List<Receiver> receivers = this.mention.parseMentions(raw);
        if (!receivers.isEmpty()) {
            this.mention.broadcastMention(sender, receivers);
        }
        return receivers;
    }

    private void applyConfig(Config config) {
        this.config = config;
        class_2960 id = class_2960.method_12829((String)config.defaultMentionSound());
        this.mention.updateConfig(class_3414.method_47908((class_2960)id), config.defaultMentionPitch(), config.defaultMentionMessage());
    }
}

