/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.EmbellishChat;
import com.hanhy06.embellish_chat.config.ConfigManager;
import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.util.Metadata;
import java.awt.Color;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StyledTextProcessor {
    private static final Pattern BOLD = Pattern.compile("(?<!\\\\)\\*\\*(.+?)\\*\\*");
    private static final Pattern UNDERLINE = Pattern.compile("(?<!\\\\)__(.+?)__");
    private static final Pattern ITALIC = Pattern.compile("(?<!\\\\)(?<!_)_([^_]+?)_(?!_)");
    private static final Pattern STRIKETHROUGH = Pattern.compile("(?<!\\\\)~~(.+?)~~");
    private static final Pattern OBFUSCATED = Pattern.compile("(?<!\\\\)\\|\\|(.+?)\\|\\|");
    private static final Pattern COLOR = Pattern.compile("(?<!\\\\)\\[(.+?)]<([^>]+)>");
    private static final Pattern OPEN_URI = Pattern.compile("(?<![\\\\!])\\[(.+?)]\\((https://[^\\s)]+)\\)");
    private static final Pattern FONT = Pattern.compile("(?<!\\\\)\\[(.+?)]\\{([^}]+)}");

    public static class_5250 applyStyles(Config config, class_5250 text, List<Receiver> receivers) {
        if (text == null || text.getString().isBlank()) {
            return text;
        }
        class_5250 result = text;
        result = StyledTextProcessor.applyDefaultColor(config, result);
        StyledTextProcessor.applyDefaultFont(config, result);
        if (receivers != null && !receivers.isEmpty()) {
            result = StyledTextProcessor.applyMention(result, receivers);
        }
        if (config.fontEnabled()) {
            result = StyledTextProcessor.applyPattern(FONT, result, StyledTextProcessor::withFont);
        }
        if (config.coloringEnabled()) {
            result = StyledTextProcessor.applyPattern(COLOR, result, StyledTextProcessor::withColor);
        }
        if (config.openUriEnabled()) {
            result = StyledTextProcessor.applyPattern(OPEN_URI, result, StyledTextProcessor::withOpenURI);
        }
        if (config.markdownEnabled()) {
            result = StyledTextProcessor.applyMarkdown(result);
        }
        result = StyledTextProcessor.removeEscapeSlashes(result);
        return Metadata.metadata(result);
    }

    private static class_5250 applyDefaultColor(Config config, class_5250 text) {
        int color = config.defaultChatColor();
        if (color > 0) {
            text.method_27696(class_2583.field_24360.method_36139(color));
            return text;
        }
        if (color < 0) {
            return StyledTextProcessor.applyRainbow(text);
        }
        return text;
    }

    private static void applyDefaultFont(Config config, class_5250 text) {
        String font = config.defaultChatFont();
        if (!font.isEmpty()) {
            text.method_27696(class_2583.field_24360.method_27704(class_2960.method_12829((String)font)));
        }
    }

    private static class_5250 applyMarkdown(class_5250 text) {
        class_5250 result = text;
        result = StyledTextProcessor.applyPattern(BOLD, result, class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyPattern(UNDERLINE, result, class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyPattern(ITALIC, result, class_2583.field_24360.method_10978(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyPattern(STRIKETHROUGH, result, class_2583.field_24360.method_36140(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyPattern(OBFUSCATED, result, class_2583.field_24360.method_36141(Boolean.valueOf(true)));
        return result;
    }

    private static class_5250 applyPattern(Pattern pattern, class_5250 text, class_2583 style) {
        String str = text.getString();
        Matcher matcher = pattern.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        matcher.reset();
        while (matcher.find()) {
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, matcher.start(1), matcher.end(1)).method_27696(style));
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, str.length()));
        return result;
    }

    private static class_5250 applyPattern(Pattern pattern, class_5250 text, Function<String, class_2583> function) {
        String str = text.getString();
        Matcher matcher = pattern.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        matcher.reset();
        while (matcher.find()) {
            class_2583 style = function.apply(matcher.group(2));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, matcher.start(1), matcher.end(1)).method_27696(style));
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, str.length()));
        return result;
    }

    private static class_2583 withColor(String strColor) {
        if (strColor.charAt(0) == '#') {
            int color = Color.decode(strColor).getRGB();
            return class_2583.field_24360.method_36139(color);
        }
        int color = ConfigManager.getConfig().defaultColorPreset().getOrDefault(strColor, 0xFFFFFF);
        return class_2583.field_24360.method_36139(color);
    }

    private static class_2583 withFont(String fontId) {
        return class_2583.field_24360.method_27704(class_2960.method_12829((String)fontId));
    }

    private static class_2583 withOpenURI(String strUri) {
        try {
            URI uri = URI.create(strUri);
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            return class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(255);
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL address: {}", (Object)strUri);
            return class_2583.field_24360;
        }
    }

    private static class_5250 applyMention(class_5250 text, List<Receiver> receivers) {
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (Receiver receiver : receivers) {
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, receiver.begin()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, receiver.begin(), receiver.end()).method_27696(class_2583.field_24360.method_36139(receiver.teamColor()).method_10982(Boolean.valueOf(true))));
            lastEnd = receiver.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, lastEnd, text.getString().length()));
        return result;
    }

    private static class_5250 applyRainbow(class_5250 text) {
        class_5250 result = class_2561.method_43473();
        int length = text.getString().length();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, 0.7f, 1.0f);
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)text, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return result;
    }

    private static class_5250 removeEscapeSlashes(class_5250 text) {
        final class_5250 result = class_2561.method_43473();
        final int[] offset = new int[]{0};
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                String replaced = content.replaceAll("\\\\([*_~#\\\\])", "$1");
                result.method_10852((class_2561)class_2561.method_43470((String)replaced).method_10862(style));
                offset[0] = offset[0] + content.length();
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return result;
    }

    private static class_5250 substring(class_2561 text, final int beginIndex, final int endIndex) {
        if (beginIndex >= endIndex || text == null) {
            return class_2561.method_43473();
        }
        final class_5250 result = class_2561.method_43473();
        final int[] currentCharacterOffset = new int[]{0};
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                int effectiveEndIndexInFullText;
                int contentStartOffset = currentCharacterOffset[0];
                int contentEndOffset = contentStartOffset + content.length();
                int effectiveStartIndexInFullText = Math.max(contentStartOffset, beginIndex);
                if (effectiveStartIndexInFullText < (effectiveEndIndexInFullText = Math.min(contentEndOffset, endIndex))) {
                    int subStartIndexInContentPiece = effectiveStartIndexInFullText - contentStartOffset;
                    int subEndIndexInContentPiece = effectiveEndIndexInFullText - contentStartOffset;
                    String subContent = content.substring(subStartIndexInContentPiece, subEndIndexInContentPiece);
                    result.method_10852((class_2561)class_2561.method_43470((String)subContent).method_10862(style));
                }
                currentCharacterOffset[0] = contentEndOffset;
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return result;
    }
}

