/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellish_chat.mention;

import io.github.hanhy06.embellish_chat.config.Config;
import io.github.hanhy06.embellish_chat.config.ConfigListener;
import io.github.hanhy06.embellish_chat.mention.data.ParsedMention;
import io.github.hanhy06.embellish_chat.mention.data.ParsedTarget;
import io.github.hanhy06.embellish_chat.mention.rule.MentionAction;
import io.github.hanhy06.embellish_chat.mention.rule.MentionParameter;
import io.github.hanhy06.embellish_chat.mention.rule.MentionRegistry;
import io.github.hanhy06.embellish_chat.mention.rule.MentionRule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import net.minecraft.class_2561;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5250;

public class MentionProcessor
implements ConfigListener {
    private final class_3324 manager;
    private final class_269 scoreboard;
    private Config config;
    private class_3414 mentionSound;
    private Map<String, List<MentionRule>> mentionRules;
    private MentionRegistry registries;

    public MentionProcessor(class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.mentionSound = class_3414.method_47908((class_2960)class_2960.method_12829((String)this.config.mentionSound()));
        this.mentionRules = this.config.mentionRules();
        this.registries = new MentionRegistry(newConfig, this.manager, this.scoreboard);
    }

    public Set<ParsedMention> parseMentions(String message, String key) {
        HashSet<ParsedMention> parsedMentions = new HashSet<ParsedMention>();
        if (!this.mentionRules.containsKey(key)) {
            return parsedMentions;
        }
        List<MentionRule> rules = this.mentionRules.get(key);
        for (MentionRule rule : rules) {
            parsedMentions.addAll(this.parseMention(rule, message));
        }
        return parsedMentions;
    }

    private List<ParsedMention> parseMention(MentionRule rule, String message) {
        Matcher matcher = rule.pattern().matcher(message);
        ArrayList<ParsedMention> mentions = new ArrayList<ParsedMention>();
        while (matcher.find()) {
            List<String> options = List.of(matcher.group(1).split(this.config.delimiter()));
            mentions.add(ParsedMention.of(rule, options, matcher.start(), matcher.end()));
        }
        return mentions;
    }

    public List<ParsedTarget> parseTargets(class_3222 sender, Set<ParsedMention> parsedMentions) {
        ArrayList<ParsedTarget> parsedTargets = new ArrayList<ParsedTarget>();
        for (ParsedMention mention : parsedMentions) {
            ParsedTarget target = this.parseTarget(sender, mention);
            parsedTargets.add(target);
        }
        return parsedTargets;
    }

    private ParsedTarget parseTarget(class_3222 sender, ParsedMention mention) {
        ArrayList<ParsedTarget> targets = new ArrayList<ParsedTarget>();
        int index = 0;
        for (MentionAction action : mention.rule().mentions()) {
            String option = action.preset();
            if (option.isBlank() && index < mention.options().size()) {
                option = mention.options().get(index);
            }
            ParsedTarget target = this.registries.get(action.mentionType()).apply(MentionParameter.of(mention, sender, option));
            targets.add(target);
            ++index;
        }
        ParsedTarget first = (ParsedTarget)targets.getFirst();
        for (int i = 1; i < targets.size(); ++i) {
            first.players().retainAll(((ParsedTarget)targets.get(i)).players());
            if (first.players().isEmpty()) break;
        }
        return first;
    }

    public void broadcastMentions(class_3222 sender, Set<class_3222> players) {
        class_5250 title = this.createTitle(sender);
        for (class_3222 player : players) {
            player.method_7353((class_2561)title, true);
            player.method_17356(this.mentionSound, class_3419.field_15248, 1.0f, this.config.mentionPitch());
        }
    }

    private class_5250 createTitle(class_3222 sender) {
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.config.mentionTitlePrefix()).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF))).method_10852(sender.method_5476()).method_10852((class_2561)class_2561.method_43470((String)this.config.mentionTitleSuffix()).method_27694(style -> style.method_10982(Boolean.valueOf(false)).method_36139(0xFFFFFF)));
    }
}

