/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.styling.rule;

import io.github.hanhy06.embellishchat.EmbellishChat;
import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.styling.rule.StyleParameter;
import io.github.hanhy06.embellishchat.styling.rule.StyleType;
import io.github.hanhy06.embellishchat.styling.util.Runs;
import io.github.hanhy06.embellishchat.styling.util.TextSliceUtil;
import java.awt.Color;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class StyleRegistry {
    private final Config config;
    private final DateTimeFormatter timestamp;
    private final HashMap<String, Color> colorPreset;
    private final EnumMap<StyleType, Function<StyleParameter, class_5250>> registers;

    public StyleRegistry(Config config) {
        this.config = config;
        this.timestamp = DateTimeFormatter.ofPattern(config.timestamp());
        this.colorPreset = config.colorPreset();
        this.registers = new EnumMap(Map.ofEntries(Map.entry(StyleType.METADATA, this::METADATA), Map.entry(StyleType.COLOR_HEX, this::COLOR_HEX), Map.entry(StyleType.COLOR_RAINBOW, this::COLOR_RAINBOW), Map.entry(StyleType.COLOR_PRESET, this::COLOR_PRESET), Map.entry(StyleType.COLOR_SHADOW, this::COLOR_SHADOW), Map.entry(StyleType.CLICK_COMMAND_RUN, this::CLICK_COMMAND_RUN), Map.entry(StyleType.CLICK_COMMAND_SUGGEST, this::CLICK_COMMAND_SUGGEST), Map.entry(StyleType.HOVER_TEXT, this::CLICK_HOVER), Map.entry(StyleType.FONT, this::FONT), Map.entry(StyleType.URL, this::URL), Map.entry(StyleType.BOLD, this::BOLD), Map.entry(StyleType.ITALIC, this::ITALIC), Map.entry(StyleType.UNDERLINE, this::UNDERLINE), Map.entry(StyleType.STRIKETHROUGH, this::STRIKETHROUGH), Map.entry(StyleType.OBFUSCATED, this::OBFUSCATED), Map.entry(StyleType.REPLACE, this::REPLACE), Map.entry(StyleType.MASK, this::MASK), Map.entry(StyleType.UPPER, this::UPPER), Map.entry(StyleType.LOWER, this::LOWER)));
    }

    public Function<StyleParameter, class_5250> get(StyleType styleType) {
        return this.registers.get((Object)styleType);
    }

    public class_5250 METADATA(StyleParameter parameter) {
        class_5250 text = parameter.text();
        String now = LocalDateTime.now().format(this.timestamp);
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)(now + "\nClick to copy to clipboard")));
        class_2558.class_10606 clickEvent = new class_2558.class_10606(now + " " + text.getString());
        return text.method_27696(class_2583.field_24360.method_10949((class_2568)hoverEvent).method_10958((class_2558)clickEvent));
    }

    public class_5250 COLOR_HEX(StyleParameter parameter) {
        int color = 0xFFFFFF;
        try {
            color = Color.decode(parameter.option()).getRGB();
        }
        catch (NumberFormatException e) {
            EmbellishChat.LOGGER.warn("Invalid hex color format: {}", (Object)parameter.option());
        }
        catch (NullPointerException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is null.");
        }
        return parameter.text().method_27696(class_2583.field_24360.method_36139(color));
    }

    public class_5250 COLOR_RAINBOW(StyleParameter parameter) {
        Runs runs = TextSliceUtil.flatten((class_2561)parameter.text());
        String string = runs.full();
        int length = string.length();
        float saturation = 0.7f;
        try {
            saturation = Float.parseFloat(parameter.option());
        }
        catch (NumberFormatException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is not a valid number.");
        }
        catch (NullPointerException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is null.");
        }
        class_5250 result = class_2561.method_43473();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, saturation, 1.0f);
            result.method_10852((class_2561)TextSliceUtil.slice(runs, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return result;
    }

    public class_5250 COLOR_PRESET(StyleParameter parameter) {
        Color color = this.colorPreset.getOrDefault(parameter.option(), Color.WHITE);
        return parameter.text().method_27696(class_2583.field_24360.method_36139(color.getRGB()));
    }

    public class_5250 COLOR_SHADOW(StyleParameter parameter) {
        int color = 0xFFFFFF;
        try {
            color = Color.decode(parameter.option()).getRGB();
        }
        catch (NumberFormatException e) {
            EmbellishChat.LOGGER.warn("Invalid hex color format: {}", (Object)parameter.option());
        }
        catch (NullPointerException e) {
            EmbellishChat.LOGGER.warn("The option value you entered is null.");
        }
        return parameter.text().method_27696(class_2583.field_24360.method_65302(color));
    }

    public class_5250 CLICK_COMMAND_RUN(StyleParameter parameter) {
        class_2558.class_10609 clickEvent = new class_2558.class_10609(parameter.option());
        return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent));
    }

    public class_5250 CLICK_COMMAND_SUGGEST(StyleParameter parameter) {
        class_2558.class_10610 clickEvent = new class_2558.class_10610(parameter.option());
        return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent));
    }

    public class_5250 CLICK_HOVER(StyleParameter parameter) {
        class_2568.class_10613 hoverEvent = new class_2568.class_10613((class_2561)class_2561.method_43470((String)parameter.option()));
        return parameter.text().method_27696(class_2583.field_24360.method_10949((class_2568)hoverEvent));
    }

    public class_5250 FONT(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_27704(class_2960.method_12829((String)parameter.option())));
    }

    public class_5250 URL(StyleParameter parameter) {
        try {
            URI uri = URI.create(parameter.option());
            class_2558.class_10608 clickEvent = new class_2558.class_10608(uri);
            return parameter.text().method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(this.config.urlColor().getRGB()));
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL provided for text [{}]: {}", (Object)parameter.text().getString(), (Object)parameter.option());
            return parameter.text();
        }
    }

    public class_5250 BOLD(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    }

    public class_5250 ITALIC(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
    }

    public class_5250 UNDERLINE(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
    }

    public class_5250 OBFUSCATED(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_36141(Boolean.valueOf(true)));
    }

    public class_5250 STRIKETHROUGH(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(true)));
    }

    public class_5250 REPLACE(StyleParameter parameter) {
        return class_2561.method_30163((String)parameter.option()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 MASK(StyleParameter parameter) {
        int length = parameter.text().getString().length();
        return class_2561.method_30163((String)parameter.option().repeat(length)).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 UPPER(StyleParameter parameter) {
        String string = parameter.text().getString();
        return class_2561.method_30163((String)string.toUpperCase()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 LOWER(StyleParameter parameter) {
        String string = parameter.text().getString();
        return class_2561.method_30163((String)string.toLowerCase()).method_27661().method_27696(parameter.text().method_10866());
    }
}

