/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.mention.rule;

import io.github.hanhy06.embellishchat.EmbellishChat;
import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.mention.data.ParsedMention;
import io.github.hanhy06.embellishchat.mention.data.ParsedTarget;
import io.github.hanhy06.embellishchat.mention.rule.MentionParameter;
import io.github.hanhy06.embellishchat.mention.rule.MentionType;
import io.github.hanhy06.embellishchat.util.LuckPermsUtil;
import io.github.hanhy06.embellishchat.util.TeamColorUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;

public class MentionRegistry {
    private final class_3324 manager;
    private final class_269 scoreboard;
    private final Config config;
    private final class_2583 stylePreset;
    private final EnumMap<MentionType, Function<MentionParameter, ParsedTarget>> registries;

    public MentionRegistry(Config config, class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
        this.config = config;
        this.stylePreset = class_2583.field_24360.method_36139(config.mentionColor().getRGB());
        this.registries = new EnumMap(Map.ofEntries(Map.entry(MentionType.EVERYONE, this::EVERYONE), Map.entry(MentionType.INSIDE, this::INSIDE), Map.entry(MentionType.TEAM, this::TEAM), Map.entry(MentionType.PLAYER, this::PLAYER), Map.entry(MentionType.LUCK_PERMS_GROUP, this::LUCK_PERMS_GROUP)));
    }

    public Function<MentionParameter, ParsedTarget> get(MentionType key) {
        return this.registries.get((Object)key);
    }

    private ParsedTarget EVERYONE(MentionParameter parameter) {
        ParsedMention mention = parameter.parsedMention();
        List players = this.manager.method_14571();
        return ParsedTarget.of(mention, players, this.stylePreset);
    }

    private ParsedTarget INSIDE(MentionParameter parameter) {
        ParsedMention mention = parameter.parsedMention();
        List<class_3222> players = PlayerLookup.around((class_3218)parameter.sender().method_51469(), (class_243)parameter.sender().method_19538(), (double)Float.parseFloat(parameter.option())).stream().toList();
        return ParsedTarget.of(mention, players, this.stylePreset);
    }

    private ParsedTarget TEAM(MentionParameter parameter) {
        class_268 team = this.scoreboard.method_1153(parameter.option());
        ParsedMention parsedMention = parameter.parsedMention();
        List<class_3222> players = new ArrayList<class_3222>();
        class_2583 style = this.stylePreset;
        if (team != null) {
            players = team.method_1204().stream().map(arg_0 -> ((class_3324)this.manager).method_14566(arg_0)).filter(Objects::nonNull).toList();
            style = team.method_1148().method_10866().method_27702(style);
        }
        return ParsedTarget.of(parsedMention, players, style);
    }

    private ParsedTarget PLAYER(MentionParameter parameter) {
        ParsedMention parsedMention = parameter.parsedMention();
        class_3222 target = this.manager.method_14566(parameter.option());
        class_2583 style = this.stylePreset;
        ArrayList<class_3222> players = new ArrayList<class_3222>();
        if (target != null) {
            style = target.method_5476().method_10866().method_27702(style);
            players.add(target);
        } else {
            style = class_2583.field_24360.method_27702(this.stylePreset).method_36139(TeamColorUtil.getPlayerColor(this.scoreboard, parameter.option(), this.config.mentionColor().getRGB()).intValue());
        }
        return ParsedTarget.of(parsedMention, players, style);
    }

    private ParsedTarget LUCK_PERMS_GROUP(MentionParameter parameter) {
        ParsedMention parsedMention = parameter.parsedMention();
        List<class_3222> players = new ArrayList<class_3222>();
        if (!FabricLoader.getInstance().isModLoaded("luckperms")) {
            EmbellishChat.LOGGER.info("LuckPerms not found. @group mentions will be ignored.");
            return ParsedTarget.of(parsedMention, players, this.stylePreset);
        }
        players = LuckPermsUtil.getGroupPlayers(parameter.option(), this.manager.method_14571());
        return ParsedTarget.of(parsedMention, players, this.stylePreset);
    }
}

