/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.message;

import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.config.ConfigListener;
import io.github.hanhy06.embellishchat.mention.MentionProcessor;
import io.github.hanhy06.embellishchat.mention.data.Mention;
import io.github.hanhy06.embellishchat.styling.StylingProcessor;
import io.github.hanhy06.embellishchat.util.PermissionUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

public class MessageProcessor
implements ConfigListener {
    public static MessageProcessor INSTANCE;
    private final MentionProcessor mentionProcessor;
    private final StylingProcessor stylingProcessor;
    private final class_3324 playerManager;
    private Config config;
    private Set<UUID> bannedPlayerList;

    public MessageProcessor(MentionProcessor mentionProcessor, StylingProcessor stylingProcessor, class_3324 playerManager) {
        INSTANCE = this;
        this.mentionProcessor = mentionProcessor;
        this.stylingProcessor = stylingProcessor;
        this.playerManager = playerManager;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.bannedPlayerList = this.config.bannedPlayerList();
    }

    public class_7471 handleMessage(class_7471 message) {
        if (this.bannedPlayerList.contains(message.method_46292())) {
            return message;
        }
        class_3222 sender = this.playerManager.method_14602(message.method_46292());
        class_5250 textMessage = message.method_46291().method_27661();
        String stringMessage = message.method_46291().getString();
        List<Mention> mentions = this.mentionProcessor.handleMention(stringMessage, PermissionUtil.getPermissions(sender, this.config.mentionRules().keySet()), sender);
        mentions.sort(Comparator.comparing(Mention::begin));
        textMessage = this.stylingProcessor.applyMention(textMessage, mentions, sender);
        textMessage = this.stylingProcessor.handleStyle(textMessage, PermissionUtil.getPermissions(sender, this.config.stylingRules().keySet()), sender);
        return message.method_44863((class_2561)textMessage);
    }
}

