/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.chat.processor;

import com.hanhy06.embellish_chat.data.Config;
import com.hanhy06.embellish_chat.data.Receiver;
import com.hanhy06.embellish_chat.util.Metadata;
import java.awt.Color;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class StyledTextProcessor {
    private static final Pattern BOLD = Pattern.compile("(?<!\\\\)\\*\\*(.+?)\\*\\*");
    private static final Pattern UNDERLINE = Pattern.compile("(?<!\\\\)__(.+?)__");
    private static final Pattern ITALIC = Pattern.compile("(?<!\\\\)(?<!_)_([^_]+?)_(?!_)");
    private static final Pattern STRIKETHROUGH = Pattern.compile("(?<!\\\\)~~(.+?)~~");
    private static final Pattern OBFUSCATED = Pattern.compile("(?<!\\\\)\\|\\|(.+?)\\|\\|");
    private static final Pattern COLOR = Pattern.compile("(?<!\\\\)(#[0-9A-Fa-f]{6})(.+?)#");
    private static final Pattern OPEN_URI = Pattern.compile("(?<!\\\\)(\\[(.+?)])\\((https?:\\/\\/[^)]+)\\)");

    public static class_5250 applyStyles(Config config, class_5250 context, List<Receiver> receivers) {
        if (context == null || context.getString().isBlank()) {
            return context;
        }
        class_5250 result = context;
        if (config.openUriEnabled()) {
            result = StyledTextProcessor.applyStyledOpenURI(result);
        }
        result = StyledTextProcessor.applyStyledMention(result, receivers);
        result = StyledTextProcessor.applyStyledColor(result);
        result = StyledTextProcessor.applyStyledPattern(BOLD, result, class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyStyledPattern(UNDERLINE, result, class_2583.field_24360.method_30938(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyStyledPattern(ITALIC, result, class_2583.field_24360.method_10978(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyStyledPattern(STRIKETHROUGH, result, class_2583.field_24360.method_36140(Boolean.valueOf(true)));
        result = StyledTextProcessor.applyStyledPattern(OBFUSCATED, result, class_2583.field_24360.method_36141(Boolean.valueOf(true)));
        result = StyledTextProcessor.removeEscapeSlashes(result);
        return Metadata.metadata(result);
    }

    private static class_5250 applyStyledPattern(Pattern pattern, class_5250 context, class_2583 style) {
        String str = context.getString();
        Matcher matcher = pattern.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        matcher.reset();
        while (matcher.find()) {
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, matcher.start(1), matcher.end(1)).method_27696(style));
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, str.length()));
        return result;
    }

    private static class_5250 applyStyledColor(class_5250 context) {
        String str = context.getString();
        Matcher matcher = COLOR.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        matcher.reset();
        while (matcher.find()) {
            Color color = Color.decode(matcher.group(1));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, matcher.start(2), matcher.end(2)).method_27696(class_2583.field_24360.method_36139(color.getRGB())));
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, str.length()));
        return result;
    }

    private static class_5250 applyStyledOpenURI(class_5250 context) {
        String str = context.getString();
        Matcher matcher = OPEN_URI.matcher(str);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        while (matcher.find()) {
            class_2558.class_10608 clickEvent = new class_2558.class_10608(URI.create(matcher.group(3)));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, matcher.start()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, matcher.start(2), matcher.end(2)).method_27696(class_2583.field_24360.method_10958((class_2558)clickEvent).method_36139(238)));
            lastEnd = matcher.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, str.length()));
        return result;
    }

    private static class_5250 applyStyledMention(class_5250 context, List<Receiver> receivers) {
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (Receiver receiver : receivers) {
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, receiver.begin()));
            result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, receiver.begin(), receiver.end()).method_27696(class_2583.field_24360.method_36139(receiver.teamColor()).method_10982(Boolean.valueOf(true))));
            lastEnd = receiver.end();
        }
        result.method_10852((class_2561)StyledTextProcessor.substring((class_2561)context, lastEnd, context.getString().length()));
        return result;
    }

    private static class_5250 removeEscapeSlashes(class_5250 context) {
        final class_5250 result = class_2561.method_43473();
        final int[] offset = new int[]{0};
        context.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                String replaced = content.replaceAll("\\\\([*_~#\\\\])", "$1");
                result.method_10852((class_2561)class_2561.method_43470((String)replaced).method_10862(style));
                offset[0] = offset[0] + content.length();
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return result;
    }

    private static class_5250 substring(class_2561 text, final int beginIndex, final int endIndex) {
        if (beginIndex >= endIndex || text == null) {
            return class_2561.method_43473();
        }
        final class_5250 result = class_2561.method_43473();
        final int[] currentCharacterOffset = new int[]{0};
        text.method_27658((class_5348.class_5246)new class_5348.class_5246<Void>(){

            public Optional<Void> accept(class_2583 style, String content) {
                int effectiveEndIndexInFullText;
                int contentStartOffset = currentCharacterOffset[0];
                int contentEndOffset = contentStartOffset + content.length();
                int effectiveStartIndexInFullText = Math.max(contentStartOffset, beginIndex);
                if (effectiveStartIndexInFullText < (effectiveEndIndexInFullText = Math.min(contentEndOffset, endIndex))) {
                    int subStartIndexInContentPiece = effectiveStartIndexInFullText - contentStartOffset;
                    int subEndIndexInContentPiece = effectiveEndIndexInFullText - contentStartOffset;
                    String subContent = content.substring(subStartIndexInContentPiece, subEndIndexInContentPiece);
                    result.method_10852((class_2561)class_2561.method_43470((String)subContent).method_10862(style));
                }
                currentCharacterOffset[0] = contentEndOffset;
                return Optional.empty();
            }
        }, class_2583.field_24360);
        return result;
    }
}

