/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.hanhy06.embellish_chat.EmbellishChat;
import com.hanhy06.embellish_chat.config.ConfigListener;
import com.hanhy06.embellish_chat.data.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class ConfigManager {
    public static ConfigManager INSTANCE;
    private final String configFileName = "embellish_chat.json";
    private final Path configFilePath;
    private Config config = Config.createDefault();
    private List<ConfigListener> listeners = new ArrayList<ConfigListener>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static Config getConfig() {
        return ConfigManager.INSTANCE.config;
    }

    public ConfigManager(Path configDirPath) {
        INSTANCE = this;
        this.configFilePath = configDirPath.resolve("embellish_chat.json");
        if (!Files.exists(this.configFilePath, new LinkOption[0])) {
            try {
                Files.createFile(this.configFilePath, new FileAttribute[0]);
                this.writeConfig();
            }
            catch (IOException e) {
                EmbellishChat.LOGGER.info("Failed to read config file. Using default config settings.");
            }
        }
    }

    public void readConfig() {
        try (BufferedReader reader = Files.newBufferedReader(this.configFilePath, StandardCharsets.UTF_8);){
            Config loaded = (Config)this.gson.fromJson((Reader)reader, Config.class);
            if (loaded != null) {
                this.config = loaded;
                this.broadcastConfig();
                EmbellishChat.LOGGER.debug("Config loaded successfully.");
            } else {
                this.writeConfig();
                EmbellishChat.LOGGER.warn("Config file is empty or invalid. Using default values.");
            }
        }
        catch (IOException e) {
            this.writeConfig();
            EmbellishChat.LOGGER.error("Failed to read config file: {}. Using default values.", (Object)this.configFilePath, (Object)e);
        }
        catch (JsonSyntaxException e) {
            this.writeConfig();
            EmbellishChat.LOGGER.error("Failed to parse config file: {}. Check JSON syntax. Using default values.", (Object)this.configFilePath, (Object)e);
        }
        catch (Exception e) {
            this.writeConfig();
            EmbellishChat.LOGGER.error("Unexpected error loading config file: {}. Using default values.", (Object)this.configFilePath, (Object)e);
        }
    }

    public void writeConfig() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFilePath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.gson.toJson((Object)this.config, (Appendable)writer);
            EmbellishChat.LOGGER.debug("Config saved successfully to {}", (Object)this.configFilePath);
        }
        catch (IOException e) {
            EmbellishChat.LOGGER.error("Failed to write config file: {}", (Object)this.configFilePath, (Object)e);
        }
        catch (Exception e) {
            EmbellishChat.LOGGER.error("Unexpected error saving config file: {}", (Object)this.configFilePath, (Object)e);
        }
    }

    public void addListener(ConfigListener listener) {
        this.listeners.add(listener);
    }

    public void broadcastConfig() {
        for (ConfigListener listener : this.listeners) {
            listener.onConfigReload(this.config);
        }
    }
}

