/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.mention.rule;

import io.github.hanhy06.embellishchat.EmbellishChat;
import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.mention.data.Target;
import io.github.hanhy06.embellishchat.mention.rule.MentionParameter;
import io.github.hanhy06.embellishchat.mention.rule.MentionType;
import io.github.hanhy06.embellishchat.util.ColorUtil;
import io.github.hanhy06.embellishchat.util.LuckPermsUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;

public class MentionRegistry {
    private final class_3324 manager;
    private final class_269 scoreboard;
    private final Config config;
    private final class_2583 stylePreset;
    private final EnumMap<MentionType, Function<MentionParameter, Target>> registries;

    public MentionRegistry(Config config, class_3324 manager, class_269 scoreboard) {
        this.manager = manager;
        this.scoreboard = scoreboard;
        this.config = config;
        this.stylePreset = class_2583.field_24360.method_36139(config.mentionColor().getRGB());
        this.registries = new EnumMap(Map.ofEntries(Map.entry(MentionType.EVERYONE, this::EVERYONE), Map.entry(MentionType.INSIDE, this::INSIDE), Map.entry(MentionType.TEAM, this::TEAM), Map.entry(MentionType.PLAYER, this::PLAYER), Map.entry(MentionType.LUCK_PERMS_GROUP, this::LUCK_PERMS_GROUP), Map.entry(MentionType.WORLD, this::WORLD)));
    }

    public Function<MentionParameter, Target> get(MentionType key) {
        return this.registries.get((Object)key);
    }

    private Target EVERYONE(MentionParameter parameter) {
        List players = this.manager.method_14571();
        return Target.of(players, this.stylePreset);
    }

    private Target INSIDE(MentionParameter parameter) {
        HashSet<class_3222> players = new HashSet<class_3222>(PlayerLookup.around((class_3218)parameter.sender().method_51469(), (class_243)parameter.sender().method_19538(), (double)Float.parseFloat(parameter.option())));
        return new Target(players, this.stylePreset);
    }

    private Target TEAM(MentionParameter parameter) {
        class_268 team = this.scoreboard.method_1153(parameter.option());
        List<class_3222> players = new ArrayList<class_3222>();
        class_2583 style = this.stylePreset;
        if (team != null) {
            players = team.method_1204().stream().map(arg_0 -> ((class_3324)this.manager).method_14566(arg_0)).filter(Objects::nonNull).toList();
            style = team.method_1148().method_10866().method_27702(style);
        }
        return Target.of(players, style);
    }

    private Target PLAYER(MentionParameter parameter) {
        class_3222 target = this.manager.method_14566(parameter.option());
        class_2583 style = this.stylePreset;
        HashSet<class_3222> players = new HashSet<class_3222>();
        if (target != null) {
            style = target.method_5476().method_10866().method_27702(style);
            players.add(target);
        } else {
            style = class_2583.field_24360.method_27702(this.stylePreset).method_36139(ColorUtil.getTeamColor(this.scoreboard, parameter.option(), this.config.mentionColor().getRGB()).intValue());
        }
        return new Target(players, style);
    }

    private Target LUCK_PERMS_GROUP(MentionParameter parameter) {
        List<class_3222> players = new ArrayList<class_3222>();
        if (!FabricLoader.getInstance().isModLoaded("luckperms")) {
            EmbellishChat.LOGGER.info("LuckPerms not found. @group mentions will be ignored.");
            return Target.of(players, this.stylePreset);
        }
        players = LuckPermsUtil.getGroupPlayers(parameter.option(), this.manager.method_14571());
        return Target.of(players, this.stylePreset);
    }

    private Target WORLD(MentionParameter parameter) {
        String worldName = parameter.option();
        MinecraftServer server = parameter.sender().method_51469().method_8503();
        class_3218 targetWorld = null;
        for (class_3218 world : server.method_3738()) {
            String id = world.method_27983().method_29177().toString();
            if (!id.equals(worldName) && !world.method_27983().method_29177().method_12832().equals(worldName)) continue;
            targetWorld = world;
            break;
        }
        ArrayList<class_3222> players = new ArrayList();
        if (targetWorld != null) {
            players = PlayerLookup.world(targetWorld).stream().toList();
        } else {
            EmbellishChat.LOGGER.info("World " + worldName + " not found. @world mention ignored.");
        }
        return Target.of(players, this.stylePreset);
    }
}

