/*
 * Decompiled with CFR 0.152.
 */
package io.github.hanhy06.embellishchat.styling;

import io.github.hanhy06.embellishchat.config.Config;
import io.github.hanhy06.embellishchat.config.ConfigListener;
import io.github.hanhy06.embellishchat.mention.data.Mention;
import io.github.hanhy06.embellishchat.styling.rule.StyleAction;
import io.github.hanhy06.embellishchat.styling.rule.StyleParameter;
import io.github.hanhy06.embellishchat.styling.rule.StyleRegistry;
import io.github.hanhy06.embellishchat.styling.rule.StylingRule;
import io.github.hanhy06.embellishchat.styling.util.Runs;
import io.github.hanhy06.embellishchat.styling.util.TextSliceUtil;
import io.github.hanhy06.embellishchat.util.OptionUtil;
import io.github.hanhy06.embellishchat.util.PlaceHolderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class StylingProcessor
implements ConfigListener {
    public static StylingProcessor INSTANCE;
    private Config config;
    private Map<String, List<StylingRule>> stylingRules;
    private StyleRegistry registry;

    public StylingProcessor() {
        INSTANCE = this;
    }

    @Override
    public void onConfigReload(Config newConfig) {
        this.config = newConfig;
        this.stylingRules = newConfig.stylingRules();
        this.registry = new StyleRegistry(newConfig);
    }

    public class_5250 handleStyle(class_5250 text, List<String> keys, class_3222 player) {
        ArrayList rules = new ArrayList();
        keys.forEach(key -> rules.addAll(this.stylingRules.get(key)));
        class_5250 result = text;
        for (StylingRule rule : rules) {
            result = this.applyStyles(result, rule, player);
        }
        return result;
    }

    public class_5250 applyStyleAPI(class_5250 text, Pattern pattern, List<Function<StyleParameter, class_5250>> functions, List<String> presets, class_3222 player) {
        Matcher matcher = pattern.matcher(text.getString());
        if (!matcher.find()) {
            return text;
        }
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        do {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, matcher.start()));
            class_5250 segment = TextSliceUtil.slice(runs, matcher.start(1), matcher.end(1));
            List<String> options = OptionUtil.split(matcher.group(2), this.config.delimiter());
            options = OptionUtil.parseOption(options, presets, player);
            for (int i = 0; i < functions.size(); ++i) {
                StyleParameter parameter = StyleParameter.of(segment, options.get(i), player);
                segment = functions.get(i).apply(parameter);
            }
            result.method_10852((class_2561)segment);
            lastEnd = matcher.end();
        } while (matcher.find());
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    private class_5250 applyStyles(class_5250 text, StylingRule style, class_3222 player) {
        Matcher matcher = style.pattern().matcher(text.getString());
        if (!matcher.find()) {
            return text;
        }
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        do {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, matcher.start()));
            class_5250 segment = TextSliceUtil.slice(runs, matcher.start(1), matcher.end(1));
            List<String> options = OptionUtil.split(matcher.group(2), this.config.delimiter());
            result.method_10852((class_2561)this.applyStyle(segment, style.styles(), options, player));
            lastEnd = matcher.end();
        } while (matcher.find());
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }

    private class_5250 applyStyle(class_5250 text, List<StyleAction> actions, List<String> options, class_3222 player) {
        class_5250 result = text;
        List<String> option = OptionUtil.parseOption(options, actions.stream().map(StyleAction::preset).toList(), player);
        for (int i = 0; i < actions.size(); ++i) {
            StyleAction action = actions.get(i);
            Function<StyleParameter, class_5250> function = this.registry.get(action.styleType());
            result = function.apply(StyleParameter.of(result, option.get(i), player));
        }
        return result;
    }

    public class_5250 applyMention(class_5250 text, List<Mention> mentions, class_3222 player) {
        Runs runs = TextSliceUtil.flatten((class_2561)text);
        class_5250 result = class_2561.method_43473();
        int lastEnd = 0;
        for (Mention mention : mentions) {
            result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, mention.begin()));
            class_5250 segment = TextSliceUtil.slice(runs, mention.begin(), mention.end());
            segment.method_27696(mention.style());
            for (StyleAction action : mention.rule().styles()) {
                String preset = PlaceHolderUtil.getParedOption(action.preset(), player).getString();
                StyleParameter parameter = StyleParameter.of(segment, preset, player);
                segment = this.registry.get(action.styleType()).apply(parameter);
            }
            result.method_10852((class_2561)segment);
            lastEnd = mention.end();
        }
        result.method_10852((class_2561)TextSliceUtil.slice(runs, lastEnd, runs.full().length()));
        return result;
    }
}

