/*
 * Decompiled with CFR 0.152.
 */
package com.hanhy06.embellish_chat.styling.rule;

import com.hanhy06.embellish_chat.EmbellishChat;
import com.hanhy06.embellish_chat.config.Config;
import com.hanhy06.embellish_chat.styling.rule.StyleParameter;
import com.hanhy06.embellish_chat.styling.rule.StyleType;
import com.hanhy06.embellish_chat.styling.util.Runs;
import com.hanhy06.embellish_chat.styling.util.TextSliceUtil;
import java.awt.Color;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class StyleRegistry {
    private final Config config;
    private final DateTimeFormatter timestamp;
    private final HashMap<String, Integer> colorPreset;
    private final EnumMap<StyleType, Function<StyleParameter, class_5250>> registers;

    public StyleRegistry(Config config) {
        this.config = config;
        this.timestamp = DateTimeFormatter.ofPattern(config.timestamp());
        this.colorPreset = config.colorPreset();
        this.registers = new EnumMap(Map.ofEntries(Map.entry(StyleType.METADATA, this::METADATA), Map.entry(StyleType.COLOR_HEX, this::COLOR_HEX), Map.entry(StyleType.COLOR_RAINBOW, this::COLOR_RAINBOW), Map.entry(StyleType.COLOR_PRESET, this::COLOR_PRESET), Map.entry(StyleType.FONT, this::FONT), Map.entry(StyleType.URL, this::URL), Map.entry(StyleType.BOLD, this::BOLD), Map.entry(StyleType.ITALIC, this::ITALIC), Map.entry(StyleType.UNDERLINE, this::UNDERLINE), Map.entry(StyleType.STRIKETHROUGH, this::STRIKETHROUGH), Map.entry(StyleType.OBFUSCATED, this::OBFUSCATED), Map.entry(StyleType.REPLACE, this::REPLACE), Map.entry(StyleType.MASK, this::MASK), Map.entry(StyleType.UPPER, this::UPPER), Map.entry(StyleType.LOWER, this::LOWER)));
    }

    public Function<StyleParameter, class_5250> get(StyleType styleType) {
        return this.registers.get((Object)styleType);
    }

    public class_5250 METADATA(StyleParameter parameter) {
        class_5250 text = parameter.text();
        String now = LocalDateTime.now().format(this.timestamp);
        class_2568 hoverEvent = new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)(now + "\nClick to copy to clipboard")));
        class_2558 clickEvent = new class_2558(class_2558.class_2559.field_21462, now + " " + text.getString());
        return text.method_27696(class_2583.field_24360.method_10949(hoverEvent).method_10958(clickEvent));
    }

    public class_5250 COLOR_HEX(StyleParameter parameter) {
        int color = Color.decode(parameter.option()).getRGB();
        return parameter.text().method_27696(class_2583.field_24360.method_36139(color));
    }

    public class_5250 COLOR_RAINBOW(StyleParameter parameter) {
        Runs runs = TextSliceUtil.flatten((class_2561)parameter.text());
        String string = runs.full();
        int length = string.length();
        float saturation = Float.parseFloat(parameter.option());
        class_5250 result = class_2561.method_43473();
        for (int i = 0; i < length; ++i) {
            float hue = (float)i / (float)length;
            int rgb = Color.HSBtoRGB(hue, saturation, 1.0f);
            result.method_10852((class_2561)TextSliceUtil.slice(runs, i, i + 1).method_27696(class_2583.field_24360.method_36139(rgb)));
        }
        return result;
    }

    public class_5250 COLOR_PRESET(StyleParameter parameter) {
        int color = this.colorPreset.getOrDefault(parameter.option(), 0xFFFFFF);
        return parameter.text().method_27696(class_2583.field_24360.method_36139(color));
    }

    public class_5250 FONT(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_27704(class_2960.method_12829((String)parameter.option())));
    }

    public class_5250 URL(StyleParameter parameter) {
        try {
            class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11749, parameter.option());
            return parameter.text().method_27696(class_2583.field_24360.method_10958(clickEvent).method_36139(this.config.urlColor()));
        }
        catch (IllegalArgumentException e) {
            EmbellishChat.LOGGER.warn("Invalid URL address: {}", (Object)parameter.option());
            return parameter.text();
        }
    }

    public class_5250 BOLD(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
    }

    public class_5250 ITALIC(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
    }

    public class_5250 UNDERLINE(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)));
    }

    public class_5250 OBFUSCATED(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_36141(Boolean.valueOf(true)));
    }

    public class_5250 STRIKETHROUGH(StyleParameter parameter) {
        return parameter.text().method_27696(class_2583.field_24360.method_36140(Boolean.valueOf(true)));
    }

    public class_5250 REPLACE(StyleParameter parameter) {
        return class_2561.method_30163((String)parameter.option()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 MASK(StyleParameter parameter) {
        int length = parameter.text().getString().length();
        return class_2561.method_30163((String)parameter.option().repeat(length)).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 UPPER(StyleParameter parameter) {
        String string = parameter.text().getString();
        return class_2561.method_30163((String)string.toUpperCase()).method_27661().method_27696(parameter.text().method_10866());
    }

    public class_5250 LOWER(StyleParameter parameter) {
        String string = parameter.text().getString();
        return class_2561.method_30163((String)string.toLowerCase()).method_27661().method_27696(parameter.text().method_10866());
    }
}

